/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.guava.collect;

import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import prefab.shaded.guava.annotations.GwtCompatible;
import prefab.shaded.guava.annotations.GwtIncompatible;
import prefab.shaded.guava.collect.ElementTypesAreNonnullByDefault;
import prefab.shaded.guava.collect.ImmutableAsList;
import prefab.shaded.guava.collect.ImmutableCollection;
import prefab.shaded.guava.collect.ImmutableList;
import prefab.shaded.guava.collect.UnmodifiableListIterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
class RegularImmutableAsList<E>
extends ImmutableAsList<E> {
    private final ImmutableCollection<E> delegate;
    private final ImmutableList<? extends E> delegateList;

    RegularImmutableAsList(ImmutableCollection<E> delegate, ImmutableList<? extends E> delegateList) {
        this.delegate = delegate;
        this.delegateList = delegateList;
    }

    RegularImmutableAsList(ImmutableCollection<E> delegate, Object[] array) {
        this(delegate, ImmutableList.asImmutableList(array));
    }

    @Override
    ImmutableCollection<E> delegateCollection() {
        return this.delegate;
    }

    ImmutableList<? extends E> delegateList() {
        return this.delegateList;
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        return this.delegateList.listIterator(index);
    }

    @Override
    @GwtIncompatible
    public void forEach(Consumer<? super E> action) {
        this.delegateList.forEach(action);
    }

    @Override
    @GwtIncompatible
    int copyIntoArray(@Nullable Object[] dst, int offset) {
        return this.delegateList.copyIntoArray(dst, offset);
    }

    @Override
    @CheckForNull
    Object[] internalArray() {
        return this.delegateList.internalArray();
    }

    @Override
    int internalArrayStart() {
        return this.delegateList.internalArrayStart();
    }

    @Override
    int internalArrayEnd() {
        return this.delegateList.internalArrayEnd();
    }

    @Override
    public E get(int index) {
        return this.delegateList.get(index);
    }
}

