/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.guava.collect;

import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import prefab.shaded.guava.annotations.GwtCompatible;
import prefab.shaded.guava.base.Preconditions;
import prefab.shaded.guava.collect.ElementTypesAreNonnullByDefault;
import prefab.shaded.guava.collect.ImmutableList;
import prefab.shaded.guava.collect.ImmutableSet;
import prefab.shaded.guava.collect.Iterators;
import prefab.shaded.guava.collect.UnmodifiableIterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableSet<E>
extends ImmutableSet<E> {
    final transient E element;

    SingletonImmutableSet(E element) {
        this.element = Preconditions.checkNotNull(element);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean contains(@CheckForNull Object target) {
        return this.element.equals(target);
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    public ImmutableList<E> asList() {
        return ImmutableList.of(this.element);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    int copyIntoArray(@Nullable Object[] dst, int offset) {
        dst[offset] = this.element;
        return offset + 1;
    }

    @Override
    public final int hashCode() {
        return this.element.hashCode();
    }

    @Override
    public String toString() {
        return '[' + this.element.toString() + ']';
    }
}

