/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.guava.util.concurrent;

import javax.annotation.CheckForNull;
import prefab.shaded.guava.annotations.GwtCompatible;
import prefab.shaded.guava.base.Preconditions;
import prefab.shaded.guava.util.concurrent.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class Platform {
    static boolean isInstanceOfThrowableClass(@CheckForNull Throwable t, Class<? extends Throwable> expectedClass) {
        return expectedClass.isInstance(t);
    }

    static void restoreInterruptIfIsInterruptedException(Throwable t) {
        Preconditions.checkNotNull(t);
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private Platform() {
    }
}

