/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client;

import cloud.prefab.client.config.ConfigChangeListener;
import cloud.prefab.client.config.logging.LogLevelChangeListener;
import cloud.prefab.client.internal.PrefabInternal;
import cloud.prefab.client.internal.TelemetryListener;
import cloud.prefab.client.internal.ThreadLocalContextStore;
import cloud.prefab.context.ContextStore;
import cloud.prefab.context.PrefabContextSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import prefab.shaded.guava.collect.ImmutableSet;

public class Options {
    private static final String DEFAULT_ENV = "default";
    private String prefabApiUrl;
    private String apikey;
    private String configOverrideDir;
    private List<String> prefabEnvs = new ArrayList<String>();
    private Datasources prefabDatasources = Datasources.ALL;
    private int initializationTimeoutSec = 10;
    private OnInitializationFailure onInitializationFailure = OnInitializationFailure.RAISE;
    private boolean collectLoggerCounts = true;
    private ContextStore contextStore = ThreadLocalContextStore.INSTANCE;
    private final Set<ConfigChangeListener> changeListenerSet = new HashSet<ConfigChangeListener>();
    private final Set<LogLevelChangeListener> logLevelChangeListeners = new HashSet<LogLevelChangeListener>();
    private boolean evaluatedConfigKeyUploadEnabled = true;
    private boolean collectEvaluationSummaries = true;
    private CollectContextMode collectContextMode = CollectContextMode.PERIODIC_EXAMPLE;
    private int telemetryUploadIntervalSeconds = 15;
    @Nullable
    private String localDatafile;
    @Nullable
    private TelemetryListener telemetryListener;
    @Nullable
    private PrefabContextSet globalContext;

    public Options() {
        this.apikey = System.getenv("PREFAB_API_KEY");
        this.prefabApiUrl = Optional.ofNullable(System.getenv("PREFAB_API_URL")).orElse("https://api.prefab.cloud");
        this.configOverrideDir = System.getProperty("user.home");
        if ("LOCAL_ONLY".equals(System.getenv("PREFAB_DATASOURCES"))) {
            this.prefabDatasources = Datasources.LOCAL_ONLY;
        }
        this.localDatafile = System.getProperty("PREFAB_DATAFILE");
    }

    public boolean isLocalOnly() {
        return Datasources.LOCAL_ONLY == this.prefabDatasources;
    }

    public String getApikey() {
        return this.apikey;
    }

    public Options setApikey(String apikey) {
        this.apikey = apikey;
        return this;
    }

    public String getConfigOverrideDir() {
        return this.configOverrideDir;
    }

    public Options setConfigOverrideDir(String configOverrideDir) {
        this.configOverrideDir = configOverrideDir;
        return this;
    }

    public String getPrefabApiUrl() {
        return this.prefabApiUrl;
    }

    public Options setPrefabApiUrl(String prefabApiUrl) {
        this.prefabApiUrl = prefabApiUrl;
        return this;
    }

    public List<String> getPrefabEnvs() {
        return this.prefabEnvs;
    }

    public Options setPrefabEnvs(List<String> prefabEnvs) {
        this.prefabEnvs = prefabEnvs;
        return this;
    }

    public Datasources getPrefabDatasource() {
        return this.prefabDatasources;
    }

    public Options setPrefabDatasource(Datasources prefabDatasources) {
        this.prefabDatasources = prefabDatasources;
        return this;
    }

    public int getInitializationTimeoutSec() {
        return this.initializationTimeoutSec;
    }

    public Options setInitializationTimeoutSec(int initializationTimeoutSec) {
        this.initializationTimeoutSec = initializationTimeoutSec;
        return this;
    }

    public OnInitializationFailure getOnInitializationFailure() {
        return this.onInitializationFailure;
    }

    public Options setOnInitializationFailure(OnInitializationFailure onInitializationFailure) {
        this.onInitializationFailure = onInitializationFailure;
        return this;
    }

    public boolean isCollectLoggerCounts() {
        return this.collectLoggerCounts;
    }

    public Options setCollectLoggerCounts(boolean collectLoggerCounts) {
        this.collectLoggerCounts = collectLoggerCounts;
        return this;
    }

    public CollectContextMode getContextUploadMode() {
        return this.collectContextMode;
    }

    public Options setContextUploadMode(CollectContextMode collectContextMode) {
        this.collectContextMode = collectContextMode;
        return this;
    }

    public boolean isCollectContextShapeEnabled() {
        return this.collectContextMode != CollectContextMode.NONE;
    }

    public boolean isCollectExampleContextEnabled() {
        return this.collectContextMode == CollectContextMode.PERIODIC_EXAMPLE;
    }

    public Options setEvaluatedConfigKeyUploadEnabled(boolean enabled) {
        this.evaluatedConfigKeyUploadEnabled = enabled;
        return this;
    }

    public boolean isEvaluatedConfigKeyUploadEnabled() {
        return this.evaluatedConfigKeyUploadEnabled;
    }

    public boolean isCollectEvaluationSummaries() {
        return this.collectEvaluationSummaries;
    }

    public Options setCollectEvaluationSummaries(boolean collectEvaluationSummaries) {
        this.collectEvaluationSummaries = collectEvaluationSummaries;
        return this;
    }

    public String getCDNUrl() {
        String envVar = System.getenv("PREFAB_CDN_URL");
        if (envVar != null) {
            return envVar;
        }
        return String.format("%s.global.ssl.fastly.net", this.prefabApiUrl.replaceAll("/$", "").replaceAll("\\.", "-"));
    }

    public List<String> getAllPrefabEnvs() {
        ArrayList<String> envs = new ArrayList<String>();
        envs.add(DEFAULT_ENV);
        envs.addAll(this.prefabEnvs);
        return envs;
    }

    public String getApiKeyId() {
        return this.getApikey().split("\\-")[0];
    }

    public Options setContextStore(ContextStore contextStore) {
        this.contextStore = contextStore;
        return this;
    }

    public ContextStore getContextStore() {
        return this.contextStore;
    }

    public Options addConfigChangeListener(ConfigChangeListener configChangeListener) {
        this.changeListenerSet.add(configChangeListener);
        return this;
    }

    public Set<ConfigChangeListener> getChangeListeners() {
        return ImmutableSet.copyOf(this.changeListenerSet);
    }

    public Options addLogLevelChangeListener(LogLevelChangeListener configChangeListener) {
        this.logLevelChangeListeners.add(configChangeListener);
        return this;
    }

    public Set<LogLevelChangeListener> getLogLevelChangeListeners() {
        return ImmutableSet.copyOf(this.logLevelChangeListeners);
    }

    @PrefabInternal
    public Options setTelemetryListener(@Nullable TelemetryListener telemetryListener) {
        this.telemetryListener = telemetryListener;
        return this;
    }

    @PrefabInternal
    public Optional<TelemetryListener> getTelemetryListener() {
        return Optional.ofNullable(this.telemetryListener);
    }

    public int getTelemetryUploadIntervalSeconds() {
        return this.telemetryUploadIntervalSeconds;
    }

    public Options setTelemetryUploadIntervalSeconds(int telemetryUploadIntervalSeconds) {
        this.telemetryUploadIntervalSeconds = telemetryUploadIntervalSeconds;
        return this;
    }

    @Nullable
    public String getLocalDatafile() {
        return this.localDatafile;
    }

    public Options setLocalDatafile(@Nullable String localDatafile) {
        this.localDatafile = localDatafile;
        return this;
    }

    public boolean isLocalDatafileMode() {
        return this.localDatafile != null;
    }

    public Optional<PrefabContextSet> getGlobalContext() {
        return Optional.ofNullable(this.globalContext);
    }

    public Options setGlobalContext(@Nullable PrefabContextSet globalContext) {
        this.globalContext = globalContext;
        return this;
    }

    public static enum Datasources {
        ALL,
        LOCAL_ONLY;

    }

    public static enum OnInitializationFailure {
        RAISE,
        UNLOCK;

    }

    public static enum CollectContextMode {
        NONE,
        SHAPE_ONLY,
        PERIODIC_EXAMPLE;

    }
}

