/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.config;

import cloud.prefab.client.config.Provenance;
import cloud.prefab.domain.Prefab;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ConfigElement {
    private Prefab.Config config;
    private Provenance provenance;
    private ConcurrentHashMap<Long, List<Prefab.ConfigRow>> preProcessedRows = new ConcurrentHashMap();

    public ConfigElement(Prefab.Config config, Provenance provenance) {
        this.config = config;
        this.provenance = provenance;
    }

    public Prefab.Config getConfig() {
        return this.config;
    }

    public Provenance getProvenance() {
        return this.provenance;
    }

    public Stream<Prefab.ConfigRow> getRowsProjEnvFirst(long projectEnvId) {
        List<Prefab.ConfigRow> configRows = this.preProcessedRows.get(projectEnvId);
        if (configRows != null) {
            return configRows.stream();
        }
        return this.preProcessedRows.computeIfAbsent(projectEnvId, key -> this.config.getRowsList().stream().filter(cr -> !cr.hasProjectEnvId() || cr.getProjectEnvId() == projectEnvId).sorted((o1, o2) -> o1.hasProjectEnvId() ? -1 : 1).collect(Collectors.toList())).stream();
    }
}

