/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.config.logging;

import cloud.prefab.client.config.logging.LogLevelChangeEvent;
import cloud.prefab.client.config.logging.LogLevelChangeListener;
import cloud.prefab.domain.Prefab;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoggingListener<LEVEL_TYPE>
implements LogLevelChangeListener {
    public static final String LOG_LEVEL_PREFIX = "log-level";
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());

    protected abstract Map<Prefab.LogLevel, LEVEL_TYPE> getValidLevels();

    protected abstract void setDefaultLevel(Optional<LEVEL_TYPE> var1);

    protected abstract void setLevel(String var1, Optional<LEVEL_TYPE> var2);

    public static boolean keyIsLogLevel(String key) {
        return key.startsWith(LOG_LEVEL_PREFIX);
    }

    @Override
    public final void onChange(LogLevelChangeEvent changeEvent) {
        Optional<Object> level = changeEvent.getNewLevel().map(newValue -> this.getValidLevels().get(newValue));
        String key = changeEvent.getLoggerName();
        if (key.equals(LOG_LEVEL_PREFIX)) {
            this.setDefaultLevel(level);
            this.LOG.info("Set default log level to '{}'", level.orElse(null));
        } else if (AbstractLoggingListener.keyIsLogLevel(key)) {
            String loggerName = key.substring(LOG_LEVEL_PREFIX.length() + 1);
            this.setLevel(loggerName, level);
            this.LOG.info("Set log level for '{}' to '{}'", (Object)loggerName, level.orElse(null));
        } else {
            this.LOG.warn("Expected log level override to start with '{}', but was '{}'", (Object)LOG_LEVEL_PREFIX, (Object)key);
        }
    }
}

