/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.config.logging;

import cloud.prefab.client.config.logging.AbstractLoggingListener;
import cloud.prefab.client.config.logging.LogLevelChangeListener;
import cloud.prefab.domain.Prefab;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import prefab.shaded.guava.collect.ImmutableMap;

public class JavaUtilLoggingConfigListener
extends AbstractLoggingListener<Level> {
    private static final LogLevelChangeListener INSTANCE = new JavaUtilLoggingConfigListener();
    private static final String ROOT_LOGGER = "";
    private static final Map<Prefab.LogLevel, Level> LEVEL_MAP = ImmutableMap.builder().put(Prefab.LogLevel.FATAL, Level.SEVERE).put(Prefab.LogLevel.ERROR, Level.SEVERE).put(Prefab.LogLevel.WARN, Level.WARNING).put(Prefab.LogLevel.INFO, Level.INFO).put(Prefab.LogLevel.DEBUG, Level.FINE).put(Prefab.LogLevel.TRACE, Level.FINER).build();

    public static LogLevelChangeListener getInstance() {
        return INSTANCE;
    }

    private JavaUtilLoggingConfigListener() {
    }

    @Override
    protected Map<Prefab.LogLevel, Level> getValidLevels() {
        return LEVEL_MAP;
    }

    @Override
    protected void setDefaultLevel(Optional<Level> level) {
        this.setLevel(ROOT_LOGGER, level);
    }

    @Override
    protected void setLevel(String loggerName, Optional<Level> level) {
        Logger logger = Logger.getLogger(loggerName);
        logger.setLevel(level.orElse(null));
    }
}

