/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.exceptions;

import cloud.prefab.client.exceptions.ConfigValueException;
import cloud.prefab.domain.Prefab;

public class EnvironmentVariableTypeConversionException
extends ConfigValueException {
    private final String configKey;
    private final String environmentVariableName;
    private final String environmentValue;
    private final Prefab.Config.ValueType targetValueType;

    public EnvironmentVariableTypeConversionException(String configKey, String environmentVariableName, String environmentValue, Prefab.Config.ValueType targetValueType, Throwable cause) {
        super(String.format("Key %s referencing environment variable %s with value %s cannot be coerced to type %s", new Object[]{configKey, environmentVariableName, environmentValue, targetValueType}), cause);
        this.configKey = configKey;
        this.environmentVariableName = environmentVariableName;
        this.environmentValue = environmentValue;
        this.targetValueType = targetValueType;
    }

    public String getEnvironmentVariableName() {
        return this.environmentVariableName;
    }

    public String getEnvironmentValue() {
        return this.environmentValue;
    }

    public Prefab.Config.ValueType getTargetValueType() {
        return this.targetValueType;
    }

    public String getConfigKey() {
        return this.configKey;
    }
}

