/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.internal;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import prefab.shaded.guava.collect.ImmutableList;
import prefab.shaded.guava.collect.MapDifference;
import prefab.shaded.guava.collect.Maps;

public abstract class AbstractConfigStoreDeltaCalculator<VALUE_TYPE, LISTENER_EVENT_TYPE> {
    public List<LISTENER_EVENT_TYPE> computeChangeEvents(Map<String, VALUE_TYPE> before, Map<String, VALUE_TYPE> after) {
        MapDifference<String, VALUE_TYPE> delta = Maps.difference(before, after);
        if (delta.areEqual()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder changeEvents = ImmutableList.builder();
        delta.entriesOnlyOnLeft().forEach((key, value) -> changeEvents.add(this.createEvent((String)key, (Optional<VALUE_TYPE>)Optional.of(value), Optional.empty())));
        delta.entriesOnlyOnRight().forEach((key, value) -> changeEvents.add(this.createEvent((String)key, Optional.empty(), (Optional<VALUE_TYPE>)Optional.of(value))));
        delta.entriesDiffering().forEach((key, values) -> changeEvents.add(this.createEvent((String)key, Optional.of(values.leftValue()), Optional.of(values.rightValue()))));
        return changeEvents.build();
    }

    abstract LISTENER_EVENT_TYPE createEvent(String var1, Optional<VALUE_TYPE> var2, Optional<VALUE_TYPE> var3);
}

