/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.internal;

import cloud.prefab.context.PrefabContextSet;
import cloud.prefab.domain.Prefab;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import prefab.shaded.guava.cache.Cache;
import prefab.shaded.guava.cache.CacheBuilder;

public class ExampleContextBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(ExampleContextBuffer.class);
    private final ContextDeduplicator contextDeduplicator;
    private Set<Prefab.ExampleContext> recentlySeenContexts = new HashSet<Prefab.ExampleContext>();

    ExampleContextBuffer() {
        this.contextDeduplicator = new ContextDeduplicator(Duration.ofMinutes(15L), 1000);
    }

    void recordContext(long timestamp, PrefabContextSet context) {
        if (context.isEmpty()) {
            return;
        }
        String fingerPrint = context.getFingerPrint();
        if (!fingerPrint.isBlank() && !this.contextDeduplicator.recentlySeen(fingerPrint)) {
            LOG.debug("have not seen context with fingerprint {} will add to recently seen contexts", (Object)fingerPrint);
            this.recentlySeenContexts.add(Prefab.ExampleContext.newBuilder().setTimestamp(timestamp).setContextSet(PrefabContextSet.convert(context).toProto()).build());
        }
    }

    Set<Prefab.ExampleContext> getAndResetContexts() {
        Set<Prefab.ExampleContext> copy = Set.copyOf(this.recentlySeenContexts);
        this.recentlySeenContexts.clear();
        return copy;
    }

    void setContexts(Set<Prefab.ExampleContext> exampleContexts) {
        this.recentlySeenContexts.addAll(exampleContexts);
    }

    static class ContextDeduplicator {
        private final Cache<String, String> cache;

        ContextDeduplicator(Duration expiry, int maxSize) {
            this.cache = CacheBuilder.newBuilder().expireAfterWrite(expiry).maximumSize(maxSize).build();
        }

        boolean recentlySeen(String fingerprint) {
            if (this.cache.getIfPresent(fingerprint) != null) {
                return true;
            }
            this.cache.put(fingerprint, fingerprint);
            return false;
        }
    }
}

