/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.internal;

import cloud.prefab.context.PrefabContext;
import cloud.prefab.context.PrefabContextSet;
import cloud.prefab.context.PrefabContextSetReadable;
import cloud.prefab.domain.Prefab;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;
import prefab.shaded.guava.collect.ImmutableMap;
import prefab.shaded.guava.collect.Maps;

public class LookupContext {
    public static final LookupContext EMPTY = new LookupContext(PrefabContextSetReadable.EMPTY);
    private final PrefabContextSet prefabContextSet;
    private Map<String, Prefab.ConfigValue> expandedProperties = null;

    public LookupContext(PrefabContextSetReadable prefabContextSetReadable) {
        this.prefabContextSet = PrefabContextSet.convert(prefabContextSetReadable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LookupContext that = (LookupContext)o;
        return Objects.equals(this.prefabContextSet, that.prefabContextSet);
    }

    public int hashCode() {
        return Objects.hash(this.prefabContextSet);
    }

    public Optional<Prefab.ConfigValue> getValue(String name) {
        return Optional.ofNullable(this.getExpandedProperties().get(name));
    }

    public PrefabContextSet getPrefabContextSet() {
        return this.prefabContextSet;
    }

    public Map<String, Prefab.ConfigValue> getExpandedProperties() {
        if (this.expandedProperties == null) {
            int propertyCount = StreamSupport.stream(this.prefabContextSet.getContexts().spliterator(), false).mapToInt(context -> context.getProperties().size()).sum() + 1;
            HashMap<CallSite, Prefab.ConfigValue> expandedProperties = Maps.newHashMapWithExpectedSize(propertyCount);
            for (PrefabContext context2 : this.prefabContextSet.getContexts()) {
                String prefix = context2.getName().isBlank() ? "" : context2.getName() + ".";
                for (Map.Entry<String, Prefab.ConfigValue> stringConfigValueEntry : context2.getProperties().entrySet()) {
                    expandedProperties.put((CallSite)((Object)(prefix + stringConfigValueEntry.getKey())), stringConfigValueEntry.getValue());
                }
            }
            this.expandedProperties = ImmutableMap.copyOf(expandedProperties);
        }
        return this.expandedProperties;
    }
}

