/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.internal;

import cloud.prefab.client.ConfigClient;
import cloud.prefab.client.config.ConfigChangeEvent;
import cloud.prefab.client.config.ConfigElement;
import cloud.prefab.client.config.Match;
import cloud.prefab.client.config.Provenance;
import cloud.prefab.client.config.logging.LogLevelChangeEvent;
import cloud.prefab.client.exceptions.ConfigValueException;
import cloud.prefab.client.internal.AbstractConfigStoreDeltaCalculator;
import cloud.prefab.client.internal.ConfigLoader;
import cloud.prefab.client.internal.ConfigResolver;
import cloud.prefab.client.internal.ConfigRuleEvaluator;
import cloud.prefab.client.internal.ConfigStoreConfigValueDeltaCalculator;
import cloud.prefab.client.internal.ConfigStoreImpl;
import cloud.prefab.client.internal.LookupContext;
import cloud.prefab.client.internal.SystemEnvVarLookup;
import cloud.prefab.client.internal.WeightedValueEvaluator;
import cloud.prefab.domain.Prefab;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import prefab.shaded.guava.collect.Maps;

public class UpdatingConfigResolver {
    private static final Logger LOG = LoggerFactory.getLogger(UpdatingConfigResolver.class);
    private final ConfigLoader configLoader;
    private final ConfigStoreConfigValueDeltaCalculator configStoreConfigValueDeltaCalculator;
    private final ConfigStoreImpl configStore;
    private final ConfigResolver configResolver;
    private final AbstractConfigStoreDeltaCalculator<Prefab.LogLevel, LogLevelChangeEvent> logLevelValueDeltaCalculator;

    public UpdatingConfigResolver(ConfigLoader configLoader, WeightedValueEvaluator weightedValueEvaluator, ConfigStoreConfigValueDeltaCalculator configStoreConfigValueDeltaCalculator) {
        this.configLoader = configLoader;
        this.configStoreConfigValueDeltaCalculator = configStoreConfigValueDeltaCalculator;
        this.logLevelValueDeltaCalculator = new AbstractConfigStoreDeltaCalculator<Prefab.LogLevel, LogLevelChangeEvent>(){

            @Override
            LogLevelChangeEvent createEvent(String name, Optional<Prefab.LogLevel> oldValue, Optional<Prefab.LogLevel> newValue) {
                return new LogLevelChangeEvent(name, oldValue, newValue);
            }
        };
        this.configStore = new ConfigStoreImpl();
        ConfigRuleEvaluator configRuleEvaluator = new ConfigRuleEvaluator(this.configStore, weightedValueEvaluator);
        this.configResolver = new ConfigResolver(this.configStore, configRuleEvaluator, new SystemEnvVarLookup());
    }

    public ChangeLists update() {
        Map<String, Prefab.Config> before = this.buildConfigByNameMap();
        Map<String, Prefab.LogLevel> logLevelsBefore = this.buildLogLevelValueMap();
        this.makeLocal();
        Map<String, Prefab.Config> after = this.buildConfigByNameMap();
        Map<String, Prefab.LogLevel> logLevelsAfter = this.buildLogLevelValueMap();
        return new ChangeLists(this.configStoreConfigValueDeltaCalculator.computeChangeEvents(before, after), this.logLevelValueDeltaCalculator.computeChangeEvents(logLevelsBefore, logLevelsAfter));
    }

    private Map<String, Prefab.LogLevel> buildLogLevelValueMap() {
        return this.configStore.entrySet().stream().filter(stringConfigElementEntry -> ((ConfigElement)stringConfigElementEntry.getValue()).getConfig().getConfigType() == Prefab.ConfigType.LOG_LEVEL || ((String)stringConfigElementEntry.getKey()).startsWith("log-level")).map(entry -> this.safeResolve((String)entry.getKey()).map(cv -> Maps.immutableEntry((String)entry.getKey(), cv)).filter(resolvedEntry -> ((Prefab.ConfigValue)resolvedEntry.getValue()).hasLogLevel())).flatMap(Optional::stream).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Prefab.ConfigValue)entry.getValue()).getLogLevel()));
    }

    private Map<String, Prefab.Config> buildConfigByNameMap() {
        return this.configStore.entrySet().stream().map(entry -> Maps.immutableEntry((String)entry.getKey(), ((ConfigElement)entry.getValue()).getConfig())).filter(entry -> ((Prefab.Config)entry.getValue()).getRowsCount() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Optional<Prefab.ConfigValue> safeResolve(String key) {
        try {
            return this.configResolver.getConfigValue(key);
        }
        catch (ConfigValueException configValueException) {
            LOG.warn("error evaluating config {} ", (Object)key, (Object)configValueException);
            return Optional.empty();
        }
    }

    public long getHighwaterMark() {
        return this.configLoader.getHighwaterMark();
    }

    public synchronized void loadConfigsFromLocalFile() {
        this.loadConfigs(this.configLoader.loadFromJsonFile(), ConfigClient.Source.LOCAL_FILE);
    }

    public synchronized void loadConfigs(Prefab.Configs configs, ConfigClient.Source source) {
        long startingHighWaterMark = this.configLoader.getHighwaterMark();
        Provenance provenance = new Provenance(source);
        this.configLoader.setConfigs(configs, provenance);
        if (this.configLoader.getHighwaterMark() > startingHighWaterMark) {
            LOG.info("Found new checkpoint with highwater id {} from {} in project {} environment: {} with {} configs", new Object[]{this.configLoader.getHighwaterMark(), provenance, configs.getConfigServicePointer().getProjectId(), configs.getConfigServicePointer().getProjectEnvId(), configs.getConfigsCount()});
        } else {
            LOG.debug("Checkpoint with highwater with highwater id {} from {}. No changes.", (Object)this.configLoader.getHighwaterMark(), (Object)provenance.getSource());
        }
    }

    private void makeLocal() {
        this.configStore.set(this.configLoader.calcConfig());
    }

    public String contentsString() {
        return this.configResolver.contentsString();
    }

    public Collection<String> getKeys() {
        return this.configResolver.getKeys();
    }

    public boolean containsKey(String key) {
        return this.configResolver.containsKey(key);
    }

    public Optional<Prefab.ConfigValue> getConfigValue(String key, LookupContext lookupContext) {
        return this.configResolver.getConfigValue(key, lookupContext);
    }

    public Optional<Prefab.ConfigValue> getConfigValue(String key) {
        return this.configResolver.getConfigValue(key);
    }

    public ConfigResolver getResolver() {
        return this.configResolver;
    }

    public Optional<Match> getMatch(String key, LookupContext lookupContext) {
        return this.configResolver.getMatch(key, lookupContext);
    }

    public Optional<Match> getRawMatch(String key, LookupContext lookupContext) {
        return this.configResolver.getRawMatch(key, lookupContext);
    }

    public static class ChangeLists {
        final List<ConfigChangeEvent> configChangeEvents;
        final List<LogLevelChangeEvent> logLevelChangeEvents;

        public ChangeLists(List<ConfigChangeEvent> configChangeEvents, List<LogLevelChangeEvent> logLevelChangeEvents) {
            this.configChangeEvents = configChangeEvents;
            this.logLevelChangeEvents = logLevelChangeEvents;
        }

        public List<ConfigChangeEvent> getConfigChangeEvents() {
            return this.configChangeEvents;
        }

        public List<LogLevelChangeEvent> getLogLevelChangeEvents() {
            return this.logLevelChangeEvents;
        }
    }
}

