/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.util;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Optional;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import prefab.shaded.guava.base.Splitter;
import prefab.shaded.guava.io.BaseEncoding;

public class SecretValueDecryptor {
    private static final Logger LOG = LoggerFactory.getLogger(SecretValueDecryptor.class);
    private static final String CIPHER_TRANSFORMATION = "AES/GCM/NoPadding";

    public static Optional<String> decryptValueQuietly(String secretKeyString, String value) {
        try {
            return Optional.of(SecretValueDecryptor.decryptValue(secretKeyString, value));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            LOG.error("unable to decrypt value {} due to exception", (Object)value, (Object)e);
            return Optional.empty();
        }
    }

    public static String decryptValue(String secretKeyString, String value) throws InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        SecretKeySpec secretKey = new SecretKeySpec(BaseEncoding.base16().decode(secretKeyString.toUpperCase()), "AES");
        List<String> parts = Splitter.on("--").limit(3).splitToList(value.toUpperCase());
        String dataStr = parts.get(0);
        String ivStr = parts.get(1);
        String authTagStr = parts.get(2);
        byte[] iv = BaseEncoding.base16().decode(ivStr);
        byte[] dataToProcess = BaseEncoding.base16().decode(dataStr + authTagStr);
        GCMParameterSpec gcmIv = new GCMParameterSpec(128, iv);
        Cipher cipher = SecretValueDecryptor.getCipher();
        cipher.init(2, (Key)secretKey, gcmIv);
        cipher.updateAAD("".getBytes());
        byte[] decryptedData = cipher.doFinal(dataToProcess);
        return new String(decryptedData);
    }

    private static Cipher getCipher() {
        try {
            return Cipher.getInstance(CIPHER_TRANSFORMATION);
        }
        catch (NoSuchPaddingException e) {
            LOG.error("NoSuchPaddingException encountered getting instance for {}", (Object)CIPHER_TRANSFORMATION, (Object)e);
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("NoSuchAlgorithmException encountered getting instance for {}", (Object)CIPHER_TRANSFORMATION, (Object)e);
            throw new RuntimeException(e);
        }
    }
}

