/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.value;

import cloud.prefab.client.ConfigClient;
import cloud.prefab.client.value.TypeMismatchException;
import cloud.prefab.client.value.UndefinedKeyException;
import cloud.prefab.client.value.Value;
import cloud.prefab.domain.Prefab;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLiveValue<T>
implements Value<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLiveValue.class);
    private final ConfigClient configClient;
    protected final String key;

    public AbstractLiveValue(ConfigClient configClient, String key) {
        this.configClient = configClient;
        this.key = key;
    }

    @Override
    public T get() {
        Optional<T> fromConfig = this.getMaybe();
        return fromConfig.orElseThrow(() -> new UndefinedKeyException("No config value for key " + this.key + " and no default defined."));
    }

    @Override
    public Optional<T> getMaybe() {
        return this.getFromConfig();
    }

    @Override
    public T orElse(T defaultValue) {
        try {
            return this.getMaybe().orElse(defaultValue);
        }
        catch (TypeMismatchException e) {
            LOG.warn("Type mismatch for key {}. Returning default value", (Object)this.key);
            return defaultValue;
        }
    }

    @Override
    public T orElseGet(Supplier<T> defaultValueSupplier) {
        try {
            return this.getMaybe().orElseGet(defaultValueSupplier);
        }
        catch (TypeMismatchException e) {
            LOG.warn("Type mismatch for key {}. returning default value", (Object)this.key);
            return defaultValueSupplier.get();
        }
    }

    @Override
    public T orNull() {
        try {
            return this.getMaybe().orElse(null);
        }
        catch (TypeMismatchException e) {
            LOG.warn("Type mismatch for key {}.", (Object)this.key);
            return null;
        }
    }

    public abstract Optional<T> resolve(Prefab.ConfigValue var1);

    private Optional<T> getFromConfig() {
        Optional<Prefab.ConfigValue> configValue = this.configClient.get(this.key);
        if (configValue.isPresent()) {
            Optional<T> resolve = this.resolve(configValue.get());
            if (resolve.isPresent()) {
                return resolve;
            }
            throw new TypeMismatchException("Config value for key " + this.key + " is not of the expected type. Is " + String.valueOf((Object)configValue.get().getTypeCase()));
        }
        return Optional.empty();
    }
}

