/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.sse;

import cloud.prefab.sse.events.CommentEvent;
import cloud.prefab.sse.events.DataEvent;
import cloud.prefab.sse.events.Event;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.concurrent.SubmissionPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSEHandler
extends SubmissionPublisher<Event>
implements Flow.Processor<String, Event> {
    public static final String EVENT_STREAM_MEDIA_TYPE = "text/event-stream";
    private static final Logger LOG = LoggerFactory.getLogger(SSEHandler.class);
    private static final String UTF8_BOM = "\ufeff";
    private static final String DEFAULT_EVENT_NAME = "message";
    private Flow.Subscription subscription;
    private String currentEventName = "message";
    private final StringBuilder dataBuffer = new StringBuilder();
    private String lastEventId = "";

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    @Override
    public void onNext(String input) {
        LOG.debug("got line `{}`", (Object)input);
        String line = this.removeTrailingNewline(this.removeLeadingBom(input));
        if (line.startsWith(":")) {
            this.submit(new CommentEvent(line.substring(1).trim()));
        } else if (line.isBlank()) {
            LOG.debug("broadcasting new event named {} lastEventId is {}", (Object)this.currentEventName, (Object)this.lastEventId);
            String dataString = this.dataBuffer.toString();
            if (!dataString.isEmpty()) {
                this.submit(new DataEvent(this.currentEventName, this.dataBuffer.toString(), this.lastEventId));
            }
            this.dataBuffer.setLength(0);
            this.currentEventName = DEFAULT_EVENT_NAME;
        } else if (line.contains(":")) {
            List<String> lineParts = List.of(line.split(":", 2));
            if (lineParts.size() == 2) {
                this.handleFieldValue(lineParts.get(0), this.stripLeadingSpaceIfPresent(lineParts.get(1)));
            }
        } else {
            this.handleFieldValue(line, "");
        }
        this.subscription.request(1L);
    }

    private void handleFieldValue(String fieldName, String value) {
        switch (fieldName) {
            case "event": {
                this.currentEventName = value;
                break;
            }
            case "data": {
                this.dataBuffer.append(value).append("\n");
                break;
            }
            case "id": {
                if (value.contains("\u0000")) break;
                this.lastEventId = value;
                break;
            }
        }
    }

    @Override
    public void onError(Throwable throwable) {
        LOG.debug("Error in SSE handler {}", (Object)throwable.getMessage());
        this.closeExceptionally(throwable);
    }

    @Override
    public void onComplete() {
        LOG.debug("SSE handler complete");
        this.close();
    }

    private String stripLeadingSpaceIfPresent(String field) {
        if (field.charAt(0) == ' ') {
            return field.substring(1);
        }
        return field;
    }

    private String removeLeadingBom(String input) {
        if (input.startsWith(UTF8_BOM)) {
            return input.substring(UTF8_BOM.length());
        }
        return input;
    }

    private String removeTrailingNewline(String input) {
        if (input.endsWith("\n")) {
            return input.substring(0, input.length() - 1);
        }
        return input;
    }
}

