/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.failsafe;

import java.time.Duration;
import prefab.shaded.failsafe.BulkheadBuilder;
import prefab.shaded.failsafe.BulkheadConfig;
import prefab.shaded.failsafe.BulkheadFullException;
import prefab.shaded.failsafe.Policy;
import prefab.shaded.failsafe.internal.BulkheadImpl;

public interface Bulkhead<R>
extends Policy<R> {
    public static <R> BulkheadBuilder<R> builder(int maxConcurrency) {
        return new BulkheadBuilder(maxConcurrency);
    }

    public static <R> BulkheadBuilder<R> builder(BulkheadConfig<R> config) {
        return new BulkheadBuilder<R>(config);
    }

    public static <R> Bulkhead<R> of(int maxConcurrency) {
        return new BulkheadImpl(new BulkheadConfig(maxConcurrency));
    }

    @Override
    public BulkheadConfig<R> getConfig();

    public void acquirePermit() throws InterruptedException;

    default public void acquirePermit(Duration maxWaitTime) throws InterruptedException {
        if (!this.tryAcquirePermit(maxWaitTime)) {
            throw new BulkheadFullException(this);
        }
    }

    public boolean tryAcquirePermit();

    public boolean tryAcquirePermit(Duration var1) throws InterruptedException;

    public void releasePermit();
}

