/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.failsafe;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import prefab.shaded.failsafe.FailurePolicyConfig;
import prefab.shaded.failsafe.PolicyBuilder;
import prefab.shaded.failsafe.function.CheckedBiPredicate;
import prefab.shaded.failsafe.function.CheckedPredicate;
import prefab.shaded.failsafe.internal.util.Assert;

public abstract class FailurePolicyBuilder<S, C extends FailurePolicyConfig<R>, R>
extends PolicyBuilder<S, C, R> {
    protected FailurePolicyBuilder(C config) {
        super(config);
    }

    public S handle(Class<? extends Throwable> exception) {
        Assert.notNull(exception, "exception");
        return this.handle(Arrays.asList(exception));
    }

    @SafeVarargs
    public final S handle(Class<? extends Throwable> ... exceptions) {
        Assert.notNull(exceptions, "exceptions");
        Assert.isTrue(exceptions.length > 0, "exceptions cannot be empty", new Object[0]);
        return this.handle(Arrays.asList(exceptions));
    }

    public S handle(List<Class<? extends Throwable>> exceptions) {
        Assert.notNull(exceptions, "exceptions");
        Assert.isTrue(!exceptions.isEmpty(), "exceptions cannot be empty", new Object[0]);
        ((FailurePolicyConfig)this.config).exceptionsChecked = true;
        ((FailurePolicyConfig)this.config).failureConditions.add(FailurePolicyBuilder.failurePredicateFor(exceptions));
        return (S)this;
    }

    public S handleIf(CheckedPredicate<? extends Throwable> failurePredicate) {
        Assert.notNull(failurePredicate, "failurePredicate");
        ((FailurePolicyConfig)this.config).exceptionsChecked = true;
        ((FailurePolicyConfig)this.config).failureConditions.add(FailurePolicyBuilder.failurePredicateFor(failurePredicate));
        return (S)this;
    }

    public S handleIf(CheckedBiPredicate<R, ? extends Throwable> resultPredicate) {
        Assert.notNull(resultPredicate, "resultPredicate");
        ((FailurePolicyConfig)this.config).exceptionsChecked = true;
        ((FailurePolicyConfig)this.config).failureConditions.add(resultPredicate);
        return (S)this;
    }

    public S handleResult(R result) {
        ((FailurePolicyConfig)this.config).failureConditions.add(FailurePolicyBuilder.resultPredicateFor(result));
        return (S)this;
    }

    public S handleResultIf(CheckedPredicate<R> resultPredicate) {
        Assert.notNull(resultPredicate, "resultPredicate");
        ((FailurePolicyConfig)this.config).failureConditions.add(FailurePolicyBuilder.resultPredicateFor(resultPredicate));
        return (S)this;
    }

    static <R> CheckedBiPredicate<R, Throwable> resultPredicateFor(R result) {
        return (t, u) -> result == null ? t == null && u == null : Objects.equals(result, t);
    }

    static <R> CheckedBiPredicate<R, Throwable> failurePredicateFor(CheckedPredicate<? extends Throwable> failurePredicate) {
        return (t, u) -> u != null && failurePredicate.test((Throwable)u);
    }

    static <R> CheckedBiPredicate<R, Throwable> resultPredicateFor(CheckedPredicate<R> resultPredicate) {
        return (t, u) -> {
            if (u == null) {
                return resultPredicate.test(t);
            }
            return false;
        };
    }

    static <R> CheckedBiPredicate<R, Throwable> failurePredicateFor(List<Class<? extends Throwable>> failures) {
        return (t, u) -> {
            if (u == null) {
                return false;
            }
            for (Class failureType : failures) {
                if (!failureType.isAssignableFrom(u.getClass())) continue;
                return true;
            }
            return false;
        };
    }
}

