/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.failsafe.internal;

import java.time.Duration;
import prefab.shaded.failsafe.RateLimiterConfig;
import prefab.shaded.failsafe.internal.RateLimiterStats;

class BurstyRateLimiterStats
extends RateLimiterStats {
    final long periodPermits;
    private final long periodNanos;
    private long availablePermits;
    private long currentPeriod;

    BurstyRateLimiterStats(RateLimiterConfig<?> config, RateLimiterStats.Stopwatch stopwatch) {
        super(stopwatch);
        this.periodPermits = config.getMaxPermits();
        this.periodNanos = config.getPeriod().toNanos();
        this.availablePermits = this.periodPermits;
    }

    @Override
    public synchronized long acquirePermits(long requestedPermits, Duration maxWaitTime) {
        long currentNanos = this.stopwatch.elapsedNanos();
        long newCurrentPeriod = currentNanos / this.periodNanos;
        if (this.currentPeriod < newCurrentPeriod) {
            long elapsedPeriods = newCurrentPeriod - this.currentPeriod;
            long elapsedPermits = elapsedPeriods * this.periodPermits;
            this.currentPeriod = newCurrentPeriod;
            this.availablePermits = this.availablePermits < 0L ? this.availablePermits + elapsedPermits : this.periodPermits;
        }
        long waitNanos = 0L;
        if (requestedPermits > this.availablePermits) {
            long nextPeriodNanos = (this.currentPeriod + 1L) * this.periodNanos;
            long nanosToNextPeriod = nextPeriodNanos - currentNanos;
            long permitDeficit = requestedPermits - this.availablePermits;
            long additionalPeriods = permitDeficit / this.periodPermits;
            long additionalUnits = permitDeficit % this.periodPermits;
            if (additionalUnits == 0L) {
                --additionalPeriods;
            }
            if (this.exceedsMaxWaitTime(waitNanos = nanosToNextPeriod + additionalPeriods * this.periodNanos, maxWaitTime)) {
                return -1L;
            }
        }
        this.availablePermits -= requestedPermits;
        return waitNanos;
    }

    synchronized long getAvailablePermits() {
        return this.availablePermits;
    }

    synchronized long getCurrentPeriod() {
        return this.currentPeriod;
    }

    @Override
    synchronized void reset() {
        this.stopwatch.reset();
        this.availablePermits = this.periodPermits;
        this.currentPeriod = 0L;
    }
}

