/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.failsafe.internal;

import java.time.Duration;
import prefab.shaded.failsafe.CircuitBreaker;
import prefab.shaded.failsafe.CircuitBreakerConfig;
import prefab.shaded.failsafe.ExecutionContext;
import prefab.shaded.failsafe.internal.CircuitBreakerImpl;
import prefab.shaded.failsafe.internal.CircuitStats;

abstract class CircuitState<R> {
    final CircuitBreakerImpl<R> breaker;
    final CircuitBreakerConfig<R> config;
    volatile CircuitStats stats;

    CircuitState(CircuitBreakerImpl<R> breaker, CircuitStats stats) {
        this.breaker = breaker;
        this.config = breaker.getConfig();
        this.stats = stats;
    }

    public Duration getRemainingDelay() {
        return Duration.ZERO;
    }

    public CircuitStats getStats() {
        return this.stats;
    }

    public abstract CircuitBreaker.State getState();

    public synchronized void recordFailure(ExecutionContext<R> context) {
        this.stats.recordFailure();
        this.checkThreshold(context);
        this.releasePermit();
    }

    public synchronized void recordSuccess() {
        this.stats.recordSuccess();
        this.checkThreshold(null);
        this.releasePermit();
    }

    public void handleConfigChange() {
    }

    void checkThreshold(ExecutionContext<R> context) {
    }

    abstract boolean tryAcquirePermit();

    void releasePermit() {
    }
}

