/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.failsafe.internal;

import prefab.shaded.failsafe.CircuitBreaker;
import prefab.shaded.failsafe.CircuitBreakerConfig;
import prefab.shaded.failsafe.internal.CountingCircuitStats;
import prefab.shaded.failsafe.internal.DefaultCircuitStats;
import prefab.shaded.failsafe.internal.TimedCircuitStats;

interface CircuitStats {
    public static CircuitStats create(CircuitBreaker<?> breaker, int capacity, boolean supportsTimeBased, CircuitStats oldStats) {
        if (supportsTimeBased && ((CircuitBreakerConfig)breaker.getConfig()).getFailureThresholdingPeriod() != null) {
            return new TimedCircuitStats(10, ((CircuitBreakerConfig)breaker.getConfig()).getFailureThresholdingPeriod(), new TimedCircuitStats.Clock(), oldStats);
        }
        if (capacity > 1) {
            return new CountingCircuitStats(capacity, oldStats);
        }
        return new DefaultCircuitStats();
    }

    default public void copyExecutions(CircuitStats oldStats) {
        int i;
        for (i = 0; i < oldStats.getSuccessCount(); ++i) {
            this.recordSuccess();
        }
        for (i = 0; i < oldStats.getFailureCount(); ++i) {
            this.recordFailure();
        }
    }

    public int getFailureCount();

    public int getExecutionCount();

    public int getSuccessCount();

    public int getFailureRate();

    public int getSuccessRate();

    public void recordFailure();

    public void recordSuccess();

    public void reset();
}

