/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.failsafe.internal;

import java.time.Duration;
import prefab.shaded.failsafe.CircuitBreaker;
import prefab.shaded.failsafe.internal.CircuitBreakerImpl;
import prefab.shaded.failsafe.internal.CircuitState;

class OpenState<R>
extends CircuitState<R> {
    private final long startTime = System.nanoTime();
    private final long delayNanos;

    public OpenState(CircuitBreakerImpl<R> breaker, CircuitState<R> previousState, Duration delay) {
        super(breaker, previousState.stats);
        this.delayNanos = delay.toNanos();
    }

    @Override
    public boolean tryAcquirePermit() {
        if (System.nanoTime() - this.startTime >= this.delayNanos) {
            this.breaker.halfOpen();
            return this.breaker.tryAcquirePermit();
        }
        return false;
    }

    @Override
    public Duration getRemainingDelay() {
        long elapsedTime = System.nanoTime() - this.startTime;
        long remainingDelay = this.delayNanos - elapsedTime;
        return Duration.ofNanos(Math.max(remainingDelay, 0L));
    }

    @Override
    public CircuitBreaker.State getState() {
        return CircuitBreaker.State.OPEN;
    }
}

