/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.failsafe.internal;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import prefab.shaded.failsafe.ExecutionContext;
import prefab.shaded.failsafe.RetryPolicyConfig;
import prefab.shaded.failsafe.internal.EventHandler;
import prefab.shaded.failsafe.internal.RetryPolicyImpl;
import prefab.shaded.failsafe.internal.util.RandomDelay;
import prefab.shaded.failsafe.spi.AsyncExecutionInternal;
import prefab.shaded.failsafe.spi.ExecutionResult;
import prefab.shaded.failsafe.spi.FailsafeFuture;
import prefab.shaded.failsafe.spi.PolicyExecutor;
import prefab.shaded.failsafe.spi.Scheduler;
import prefab.shaded.failsafe.spi.SyncExecutionInternal;

public class RetryPolicyExecutor<R>
extends PolicyExecutor<R> {
    private final RetryPolicyImpl<R> retryPolicy;
    private final RetryPolicyConfig<R> config;
    private volatile int failedAttempts;
    private volatile boolean retriesExceeded;
    private volatile long lastDelayNanos;
    private final EventHandler<R> abortHandler;
    private final EventHandler<R> failedAttemptHandler;
    private final EventHandler<R> retriesExceededHandler;
    private final EventHandler<R> retryHandler;
    private final EventHandler<R> retryScheduledHandler;

    public RetryPolicyExecutor(RetryPolicyImpl<R> retryPolicy, int policyIndex) {
        super(retryPolicy, policyIndex);
        this.retryPolicy = retryPolicy;
        this.config = retryPolicy.getConfig();
        this.abortHandler = EventHandler.ofExecutionCompleted(this.config.getAbortListener());
        this.failedAttemptHandler = EventHandler.ofExecutionAttempted(this.config.getFailedAttemptListener());
        this.retriesExceededHandler = EventHandler.ofExecutionCompleted(this.config.getRetriesExceededListener());
        this.retryHandler = EventHandler.ofExecutionAttempted(this.config.getRetryListener());
        this.retryScheduledHandler = EventHandler.ofExecutionScheduled(this.config.getRetryScheduledListener());
    }

    @Override
    public Function<SyncExecutionInternal<R>, ExecutionResult<R>> apply(Function<SyncExecutionInternal<R>, ExecutionResult<R>> innerFn, Scheduler scheduler) {
        return execution -> {
            while (true) {
                ExecutionResult result = (ExecutionResult)innerFn.apply((SyncExecutionInternal<R>)execution);
                if (this.retriesExceeded || execution.isCancelled(this)) {
                    return result;
                }
                if ((result = this.postExecute(execution, result)).isComplete() || execution.isCancelled(this)) {
                    return result;
                }
                try {
                    if (this.retryScheduledHandler != null) {
                        this.retryScheduledHandler.handle(result, execution);
                    }
                    execution.setInterruptable(true);
                    Thread.sleep(TimeUnit.NANOSECONDS.toMillis(result.getDelay()));
                }
                catch (InterruptedException e) {
                    if (!execution.isInterrupted()) {
                        Thread.currentThread().interrupt();
                    }
                    ExecutionResult executionResult = ExecutionResult.exception(e);
                    return executionResult;
                }
                finally {
                    execution.setInterruptable(false);
                }
                Object object = execution.getLock();
                synchronized (object) {
                    if (execution.isCancelled(this)) {
                        return result;
                    }
                    execution = execution.copy();
                }
                if (this.retryHandler == null) continue;
                this.retryHandler.handle(result, execution);
            }
        };
    }

    @Override
    public Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> applyAsync(Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> innerFn, Scheduler scheduler, FailsafeFuture<R> future) {
        return initialRequest -> {
            CompletableFuture<ExecutionResult<R>> promise = new CompletableFuture<ExecutionResult<R>>();
            AtomicReference<ExecutionResult<R>> previousResultRef = new AtomicReference<ExecutionResult<R>>();
            try {
                this.handleAsync((AsyncExecutionInternal<R>)initialRequest, innerFn, scheduler, future, promise, previousResultRef);
            }
            catch (Throwable t) {
                promise.completeExceptionally(t);
            }
            return promise;
        };
    }

    public Object handleAsync(AsyncExecutionInternal<R> execution, Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> innerFn, Scheduler scheduler, FailsafeFuture<R> future, CompletableFuture<ExecutionResult<R>> promise, AtomicReference<ExecutionResult<R>> previousResultRef) {
        ExecutionResult<R> previousResult = previousResultRef.get();
        if (this.retryHandler != null && !execution.isRecorded() && previousResult != null) {
            this.retryHandler.handle(previousResult, execution);
        }
        innerFn.apply(execution).whenComplete((result, error) -> {
            if (this.isValidResult((ExecutionResult<R>)result, (Throwable)error, promise)) {
                if (this.retriesExceeded || execution.isCancelled(this)) {
                    promise.complete((ExecutionResult<R>)result);
                } else {
                    this.postExecuteAsync(execution, result, scheduler, future).whenComplete((postResult, postError) -> {
                        if (this.isValidResult((ExecutionResult<R>)postResult, (Throwable)postError, promise)) {
                            Object object = execution.getLock();
                            synchronized (object) {
                                if (postResult.isComplete() || execution.isCancelled(this)) {
                                    promise.complete((ExecutionResult<R>)postResult);
                                    return;
                                }
                                FailsafeFuture failsafeFuture = future;
                                synchronized (failsafeFuture) {
                                    if (!future.isDone()) {
                                        try {
                                            if (this.retryScheduledHandler != null) {
                                                this.retryScheduledHandler.handle((ExecutionResult<R>)postResult, execution);
                                            }
                                            previousResultRef.set((ExecutionResult<R>)postResult);
                                            AsyncExecutionInternal retryExecution = execution.copy();
                                            future.setExecution(retryExecution);
                                            Callable<Object> retryFn = () -> this.handleAsync(retryExecution, innerFn, scheduler, future, promise, previousResultRef);
                                            ScheduledFuture<?> scheduledRetry = scheduler.schedule(retryFn, postResult.getDelay(), TimeUnit.NANOSECONDS);
                                            future.cancelDependencies(this, false, null);
                                            future.setCancelFn(-1, (mayInterrupt, cancelResult) -> scheduledRetry.cancel((boolean)mayInterrupt));
                                            future.setCancelFn(this, (mayInterrupt, cancelResult) -> promise.complete((ExecutionResult)cancelResult));
                                        }
                                        catch (Throwable t) {
                                            promise.completeExceptionally(t);
                                        }
                                    }
                                }
                            }
                        }
                    });
                }
            }
        });
        return null;
    }

    boolean isValidResult(ExecutionResult<R> result, Throwable error, CompletableFuture<ExecutionResult<R>> promise) {
        if (error != null) {
            promise.completeExceptionally(error);
            return false;
        }
        if (result == null) {
            promise.complete(null);
            return false;
        }
        return true;
    }

    @Override
    public ExecutionResult<R> onFailure(ExecutionContext<R> context, ExecutionResult<R> result) {
        boolean success;
        if (this.failedAttemptHandler != null) {
            this.failedAttemptHandler.handle(result, context);
        }
        ++this.failedAttempts;
        long delayNanos = this.lastDelayNanos;
        Duration computedDelay = this.retryPolicy.computeDelay(context);
        if (computedDelay != null) {
            delayNanos = computedDelay.toNanos();
        } else {
            delayNanos = this.getFixedOrRandomDelayNanos(delayNanos);
            this.lastDelayNanos = delayNanos = this.adjustForBackoff(context, delayNanos);
        }
        if (delayNanos != 0L) {
            delayNanos = this.adjustForJitter(delayNanos);
        }
        long elapsedNanos = context.getElapsedTime().toNanos();
        delayNanos = this.adjustForMaxDuration(delayNanos, elapsedNanos);
        boolean maxRetriesExceeded = this.config.getMaxRetries() != -1 && this.failedAttempts > this.config.getMaxRetries();
        boolean maxDurationExceeded = this.config.getMaxDuration() != null && elapsedNanos > this.config.getMaxDuration().toNanos();
        this.retriesExceeded = maxRetriesExceeded || maxDurationExceeded;
        boolean isAbortable = this.retryPolicy.isAbortable(result.getResult(), result.getException());
        boolean shouldRetry = !result.isSuccess() && !isAbortable && !this.retriesExceeded && this.config.allowsRetries();
        boolean completed = isAbortable || !shouldRetry;
        boolean bl = success = completed && result.isSuccess() && !isAbortable;
        if (this.abortHandler != null && isAbortable) {
            this.abortHandler.handle(result, context);
        } else if (this.retriesExceededHandler != null && !success && this.retriesExceeded) {
            this.retriesExceededHandler.handle(result, context);
        }
        return result.with(delayNanos, completed, success);
    }

    @Override
    public CompletableFuture<ExecutionResult<R>> onFailureAsync(ExecutionContext<R> context, ExecutionResult<R> result, Scheduler scheduler, FailsafeFuture<R> future) {
        return super.onFailureAsync(context, result.withNotComplete(), scheduler, future);
    }

    private long getFixedOrRandomDelayNanos(long delayNanos) {
        Duration delay = this.config.getDelay();
        Duration delayMin = this.config.getDelayMin();
        Duration delayMax = this.config.getDelayMax();
        if (delayNanos == 0L && delay != null && !delay.equals(Duration.ZERO)) {
            delayNanos = delay.toNanos();
        } else if (delayMin != null && delayMax != null) {
            delayNanos = RandomDelay.randomDelayInRange(delayMin.toNanos(), delayMax.toNanos(), Math.random());
        }
        return delayNanos;
    }

    private long adjustForBackoff(ExecutionContext<R> context, long delayNanos) {
        if (context.getAttemptCount() != 1 && this.config.getMaxDelay() != null) {
            delayNanos = (long)Math.min((double)delayNanos * this.config.getDelayFactor(), (double)this.config.getMaxDelay().toNanos());
        }
        return delayNanos;
    }

    private long adjustForJitter(long delayNanos) {
        if (this.config.getJitter() != null) {
            delayNanos = RandomDelay.randomDelay(delayNanos, this.config.getJitter().toNanos(), Math.random());
        } else if (this.config.getJitterFactor() > 0.0) {
            delayNanos = RandomDelay.randomDelay(delayNanos, this.config.getJitterFactor(), Math.random());
        }
        return delayNanos;
    }

    private long adjustForMaxDuration(long delayNanos, long elapsedNanos) {
        long maxRemainingDelay;
        if (this.config.getMaxDuration() != null && (delayNanos = Math.min(delayNanos, (maxRemainingDelay = this.config.getMaxDuration().toNanos() - elapsedNanos) < 0L ? 0L : maxRemainingDelay)) < 0L) {
            delayNanos = 0L;
        }
        return delayNanos;
    }
}

