/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.failsafe.spi;

import java.time.Duration;
import prefab.shaded.failsafe.DelayablePolicyConfig;
import prefab.shaded.failsafe.ExecutionContext;
import prefab.shaded.failsafe.Policy;
import prefab.shaded.failsafe.PolicyConfig;
import prefab.shaded.failsafe.internal.util.Durations;

public interface DelayablePolicy<R>
extends Policy<R> {
    @Override
    public DelayablePolicyConfig<R> getConfig();

    default public Duration computeDelay(ExecutionContext<R> context) {
        PolicyConfig config = this.getConfig();
        Duration computed = null;
        if (context != null && ((DelayablePolicyConfig)config).getDelayFn() != null) {
            boolean delayExceptionMatched;
            R result = context.getLastResult();
            Object exception = context.getLastException();
            Object delayResult = ((DelayablePolicyConfig)config).getDelayResult();
            Class<Throwable> delayFailure = ((DelayablePolicyConfig)config).getDelayException();
            boolean delayResultMatched = delayResult == null || delayResult.equals(result);
            boolean bl = delayExceptionMatched = delayFailure == null || exception != null && delayFailure.isAssignableFrom(exception.getClass());
            if (delayResultMatched && delayExceptionMatched) {
                try {
                    computed = Durations.ofSafeNanos(((DelayablePolicyConfig)config).getDelayFn().get(context));
                }
                catch (Throwable e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
        }
        return computed != null && !computed.isNegative() ? computed : null;
    }
}

