/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.guava.collect;

import java.util.Collections;
import java.util.Spliterator;
import prefab.shaded.guava.annotations.GwtCompatible;
import prefab.shaded.guava.base.Preconditions;
import prefab.shaded.guava.collect.ElementTypesAreNonnullByDefault;
import prefab.shaded.guava.collect.ImmutableList;
import prefab.shaded.guava.collect.Iterators;
import prefab.shaded.guava.collect.UnmodifiableIterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableList<E>
extends ImmutableList<E> {
    final transient E element;

    SingletonImmutableList(E element) {
        this.element = Preconditions.checkNotNull(element);
    }

    @Override
    public E get(int index) {
        Preconditions.checkElementIndex(index, 1);
        return this.element;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Collections.singleton(this.element).spliterator();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        Preconditions.checkPositionIndexes(fromIndex, toIndex, 1);
        return fromIndex == toIndex ? ImmutableList.of() : this;
    }

    @Override
    public String toString() {
        return '[' + this.element.toString() + ']';
    }

    @Override
    boolean isPartialView() {
        return false;
    }
}

