/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.guava.graph;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import prefab.shaded.guava.collect.BiMap;
import prefab.shaded.guava.collect.HashBiMap;
import prefab.shaded.guava.collect.ImmutableBiMap;
import prefab.shaded.guava.graph.AbstractUndirectedNetworkConnections;
import prefab.shaded.guava.graph.EdgesConnecting;
import prefab.shaded.guava.graph.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
final class UndirectedNetworkConnections<N, E>
extends AbstractUndirectedNetworkConnections<N, E> {
    UndirectedNetworkConnections(Map<E, N> incidentEdgeMap) {
        super(incidentEdgeMap);
    }

    static <N, E> UndirectedNetworkConnections<N, E> of() {
        return new UndirectedNetworkConnections(HashBiMap.create(2));
    }

    static <N, E> UndirectedNetworkConnections<N, E> ofImmutable(Map<E, N> incidentEdges) {
        return new UndirectedNetworkConnections<N, E>(ImmutableBiMap.copyOf(incidentEdges));
    }

    @Override
    public Set<N> adjacentNodes() {
        return Collections.unmodifiableSet(((BiMap)this.incidentEdgeMap).values());
    }

    @Override
    public Set<E> edgesConnecting(N node) {
        return new EdgesConnecting(((BiMap)this.incidentEdgeMap).inverse(), node);
    }
}

