/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.guava.util.concurrent;

import java.util.concurrent.Callable;
import prefab.shaded.guava.annotations.GwtCompatible;
import prefab.shaded.guava.annotations.GwtIncompatible;
import prefab.shaded.guava.annotations.J2ktIncompatible;
import prefab.shaded.guava.base.Preconditions;
import prefab.shaded.guava.base.Supplier;
import prefab.shaded.guava.util.concurrent.AsyncCallable;
import prefab.shaded.guava.util.concurrent.ElementTypesAreNonnullByDefault;
import prefab.shaded.guava.util.concurrent.ListeningExecutorService;
import prefab.shaded.guava.util.concurrent.ParametricNullness;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Callables {
    private Callables() {
    }

    public static <T> Callable<T> returning(@ParametricNullness T value) {
        return () -> value;
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <T> AsyncCallable<T> asAsyncCallable(Callable<T> callable, ListeningExecutorService listeningExecutorService) {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(listeningExecutorService);
        return () -> listeningExecutorService.submit(callable);
    }

    @J2ktIncompatible
    @GwtIncompatible
    static <T> Callable<T> threadRenaming(Callable<T> callable, Supplier<String> nameSupplier) {
        Preconditions.checkNotNull(nameSupplier);
        Preconditions.checkNotNull(callable);
        return () -> {
            Thread currentThread = Thread.currentThread();
            String oldName = currentThread.getName();
            boolean restoreName = Callables.trySetName((String)nameSupplier.get(), currentThread);
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                if (restoreName) {
                    boolean bl = Callables.trySetName(oldName, currentThread);
                }
            }
        };
    }

    @J2ktIncompatible
    @GwtIncompatible
    static Runnable threadRenaming(Runnable task, Supplier<String> nameSupplier) {
        Preconditions.checkNotNull(nameSupplier);
        Preconditions.checkNotNull(task);
        return () -> {
            Thread currentThread = Thread.currentThread();
            String oldName = currentThread.getName();
            boolean restoreName = Callables.trySetName((String)nameSupplier.get(), currentThread);
            try {
                task.run();
            }
            finally {
                if (restoreName) {
                    boolean bl = Callables.trySetName(oldName, currentThread);
                }
            }
        };
    }

    @J2ktIncompatible
    @GwtIncompatible
    private static boolean trySetName(String threadName, Thread currentThread) {
        try {
            currentThread.setName(threadName);
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }
}

