/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.guava.util.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import prefab.shaded.guava.annotations.GwtCompatible;
import prefab.shaded.guava.base.Preconditions;
import prefab.shaded.guava.util.concurrent.ElementTypesAreNonnullByDefault;
import prefab.shaded.guava.util.concurrent.FluentFuture;
import prefab.shaded.guava.util.concurrent.ListenableFuture;
import prefab.shaded.guava.util.concurrent.ParametricNullness;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class ForwardingFluentFuture<V>
extends FluentFuture<V> {
    private final ListenableFuture<V> delegate;

    ForwardingFluentFuture(ListenableFuture<V> delegate) {
        this.delegate = Preconditions.checkNotNull(delegate);
    }

    @Override
    public void addListener(Runnable listener, Executor executor) {
        this.delegate.addListener(listener, executor);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    @ParametricNullness
    public V get() throws InterruptedException, ExecutionException {
        return this.delegate.get();
    }

    @Override
    @ParametricNullness
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.get(timeout, unit);
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

