/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

public class ClientAuthenticationInterceptor
implements ClientInterceptor {
    public static final Metadata.Key<String> CUSTOM_HEADER_KEY = Metadata.Key.of((String)"auth", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private String apikey;

    public ClientAuthenticationInterceptor(String apikey) {
        this.apikey = apikey;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(channel.newCall(methodDescriptor, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                headers.put(CUSTOM_HEADER_KEY, (Object)ClientAuthenticationInterceptor.this.apikey);
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){}, headers);
            }
        };
    }
}

