/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client;

import cloud.prefab.client.PrefabCloudClient;
import cloud.prefab.client.config.ConfigResolver;
import cloud.prefab.domain.ConfigServiceGrpc;
import cloud.prefab.domain.Prefab;
import com.hubspot.liveconfig.LiveConfig;
import com.hubspot.liveconfig.resolver.Resolver;
import io.grpc.Channel;
import java.util.Optional;

public class ConfigClient {
    private final PrefabCloudClient baseClient;
    private final String namespace;
    private final LiveConfig liveConfig;
    private final ConfigResolver resolver;

    public ConfigClient(String namespace, PrefabCloudClient baseClient) {
        this.baseClient = baseClient;
        this.namespace = namespace;
        this.resolver = new ConfigResolver(baseClient);
        this.liveConfig = LiveConfig.builder().usingEnvironmentVariables().usingSystemProperties().usingResolver((Resolver)this.resolver).build();
    }

    public LiveConfig getLiveConfig() {
        return this.liveConfig;
    }

    public Optional<Prefab.ConfigValue> get(String key) {
        return (Optional)this.resolver.getConfigValue(key).transform(Optional::of).or(Optional.empty());
    }

    public void upsert(Prefab.UpsertRequest upsertRequest) {
        this.configServiceStub().upsert(upsertRequest);
    }

    private ConfigServiceGrpc.ConfigServiceBlockingStub configServiceStub() {
        return ConfigServiceGrpc.newBlockingStub((Channel)this.baseClient.getChannel());
    }
}

