/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client;

import cloud.prefab.client.PrefabCloudClient;
import cloud.prefab.domain.Prefab;
import cloud.prefab.domain.RateLimitServiceGrpc;
import io.grpc.Channel;

public class RateLimitClient {
    private Prefab.OnFailure defaultOnFailure = Prefab.OnFailure.LOG_AND_PASS;
    private final PrefabCloudClient baseClient;

    public RateLimitClient(PrefabCloudClient baseClient) {
        this.baseClient = baseClient;
    }

    public boolean isPass(Prefab.LimitRequest limitRequest) {
        return this.acquire(limitRequest, this.defaultOnFailure).getPassed();
    }

    public Prefab.LimitResponse acquire(Prefab.LimitRequest limitRequest, Prefab.OnFailure onFailure) {
        limitRequest = limitRequest.toBuilder().setAccountId(this.baseClient.getAccountId()).build();
        RateLimitServiceGrpc.RateLimitServiceBlockingStub rateLimitServiceBlockingStub = RateLimitServiceGrpc.newBlockingStub((Channel)this.baseClient.getChannel());
        try {
            Prefab.LimitResponse limitResponse = rateLimitServiceBlockingStub.limitCheck(limitRequest);
            return limitResponse;
        }
        catch (Exception e) {
            String message = String.format("ratelimit for %s error: %s", limitRequest.getGroupsList(), e.getMessage());
            switch (onFailure) {
                case THROW: {
                    throw e;
                }
                case LOG_AND_FAIL: {
                    this.baseClient.logInternal(message);
                    return Prefab.LimitResponse.newBuilder().setAmount(0L).setPassed(false).build();
                }
            }
            this.baseClient.logInternal(message);
            return Prefab.LimitResponse.newBuilder().setAmount(limitRequest.getAcquireAmount()).setPassed(true).build();
        }
    }

    public void upsert(Prefab.LimitDefinition limitDefinition) {
        RateLimitServiceGrpc.RateLimitServiceBlockingStub rateLimitServiceBlockingStub = RateLimitServiceGrpc.newBlockingStub((Channel)this.baseClient.getChannel());
        Prefab.BasicResponse basicResponse = rateLimitServiceBlockingStub.upsertLimitDefinition(limitDefinition);
    }
}

