/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.config;

import cloud.prefab.client.PrefabCloudClient;
import cloud.prefab.domain.ConfigServiceGrpc;
import cloud.prefab.domain.Prefab;
import com.google.common.base.Optional;
import com.hubspot.liveconfig.resolver.Resolver;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ConfigResolver
implements Resolver {
    private final PrefabCloudClient baseClient;
    private ConcurrentMap<String, Prefab.ConfigDelta> map = new ConcurrentHashMap<String, Prefab.ConfigDelta>();

    public ConfigResolver(PrefabCloudClient baseClient) {
        this.baseClient = baseClient;
        Prefab.ConfigServicePointer pointer = Prefab.ConfigServicePointer.newBuilder().setStartAtId(0L).setAccountId(baseClient.getAccountId()).build();
        this.configServiceStub().getConfig(pointer, new StreamObserver<Prefab.ConfigDeltas>(){

            public void onNext(Prefab.ConfigDeltas configDeltas) {
                for (Prefab.ConfigDelta configDelta : configDeltas.getDeltasList()) {
                    Prefab.ConfigDelta currentVal = (Prefab.ConfigDelta)ConfigResolver.this.map.get(configDelta.getKey());
                    if (currentVal != null && currentVal.getId() >= configDelta.getId()) continue;
                    ConfigResolver.this.map.put(configDelta.getKey(), configDelta);
                }
            }

            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }

            public void onCompleted() {
            }
        });
    }

    public Optional<Prefab.ConfigValue> getConfigValue(String key) {
        Prefab.ConfigDelta configDelta = (Prefab.ConfigDelta)this.map.get(key);
        if (configDelta != null) {
            return Optional.of((Object)configDelta.getValue());
        }
        return Optional.absent();
    }

    public Optional<String> get(String key) {
        Optional<Prefab.ConfigValue> configValue = this.getConfigValue(key);
        if (configValue.isPresent()) {
            return Optional.of((Object)((Prefab.ConfigValue)configValue.get()).toString());
        }
        return Optional.absent();
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    private ConfigServiceGrpc.ConfigServiceStub configServiceStub() {
        return ConfigServiceGrpc.newStub((Channel)this.baseClient.getChannel());
    }
}

