/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.chaos.web.config;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.servlet.mvc.condition.RequestCondition;

public class FastApiCondition
implements RequestCondition<FastApiCondition> {
    private static final Pattern VERSION_PREFIX_PATTERN = Pattern.compile("/v(\\d+)/");
    private int apiVersion;

    public FastApiCondition(int apiVersion) {
        this.apiVersion = apiVersion;
    }

    public FastApiCondition combine(FastApiCondition other) {
        return new FastApiCondition(other.getApiVersion());
    }

    public FastApiCondition getMatchingCondition(HttpServletRequest request) {
        Integer version;
        Matcher matcher = VERSION_PREFIX_PATTERN.matcher(request.getRequestURI());
        if (matcher.find() && (version = Integer.valueOf(matcher.group(1))) >= this.getApiVersion()) {
            return this;
        }
        return null;
    }

    public int compareTo(FastApiCondition condition, HttpServletRequest request) {
        return condition.getApiVersion() - this.getApiVersion();
    }

    public int getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(int apiVersion) {
        this.apiVersion = apiVersion;
    }
}

