/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.chaos.web.config;

import club.gclmit.chaos.web.annotation.FastApi;
import club.gclmit.chaos.web.config.FastApiCondition;
import java.lang.reflect.Method;
import java.util.Objects;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class FastApiRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    protected RequestCondition<?> getCustomTypeCondition(Class<?> handlerType) {
        FastApi version = (FastApi)AnnotationUtils.findAnnotation(handlerType, FastApi.class);
        return this.createRequestCondition(version);
    }

    protected RequestCondition<?> getCustomMethodCondition(Method method) {
        FastApi fastApi = (FastApi)AnnotationUtils.findAnnotation((Method)method, FastApi.class);
        return this.createRequestCondition(fastApi);
    }

    private RequestCondition<FastApiCondition> createRequestCondition(FastApi version) {
        if (Objects.isNull(version)) {
            return null;
        }
        int versionValue = version.value();
        Assert.isTrue((versionValue >= 1 ? 1 : 0) != 0, (String)"Api \u7248\u672c\u4e0d\u80fd\u5c0f\u4e8e 1");
        return new FastApiCondition(versionValue);
    }
}

