/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.chaos.web.config;

import club.gclmit.chaos.core.utils.MapUtils;
import club.gclmit.chaos.core.utils.StringUtils;
import club.gclmit.chaos.web.annotation.ChaosQuery;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class QueryHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(QueryHandlerMethodArgumentResolver.class);

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(ChaosQuery.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        ChaosQuery chaosQuery = (ChaosQuery)parameter.getParameterAnnotation(ChaosQuery.class);
        if (chaosQuery == null) {
            throw new IllegalArgumentException("Unknown parameter type [" + parameter.getParameterType().getName() + "]");
        }
        Class<?> clazz = chaosQuery.clazz();
        log.info("chaos --> \u5f53\u524d\u8f6c\u6362Class:[{}]", (Object)clazz.getName());
        Map params = webRequest.getParameterMap();
        Object obj = MapUtils.mapToObject((Map)params, clazz);
        log.info("chaos --> \u89e3\u6790\u540eObject:[{}]", (Object)StringUtils.toString((Object)obj));
        return obj;
    }
}

