/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.chaos.web.controller;

import club.gclmit.chaos.core.exception.ChaosException;
import club.gclmit.chaos.web.result.ApiResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
public class GlobalExceptionHandler {
    @ExceptionHandler(value={BindException.class, MethodArgumentNotValidException.class})
    public ApiResult validationExceptionHandler(Exception exception) {
        BindingResult bindResult = null;
        if (exception instanceof BindException) {
            bindResult = ((BindException)exception).getBindingResult();
        }
        StringBuilder message = new StringBuilder();
        if (bindResult != null && bindResult.hasErrors()) {
            bindResult.getAllErrors().forEach(objectError -> message.append(objectError.getDefaultMessage()).append(","));
        } else {
            message.append("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5...");
        }
        return ApiResult.fail(message.substring(0, message.length() - 1));
    }

    @ExceptionHandler(value={ChaosException.class})
    public ApiResult chaosException(Exception exception) {
        return ApiResult.fail(exception.getMessage());
    }
}

