/*
 * Decompiled with CFR 0.152.
 */
package club.gclmit.chaos.web.result;

import club.gclmit.chaos.core.utils.DateUtils;
import club.gclmit.chaos.core.utils.StringUtils;
import club.gclmit.chaos.web.result.ApiCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;

@ApiModel(value="\u901a\u7528\u6d88\u606f\u54cd\u5e94", description="\u901a\u7528\u6d88\u606f\u54cd\u5e94")
public class ApiResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TIMESTAMP = String.valueOf(DateUtils.getMilliTimestamp());
    @ApiModelProperty(value="\u54cd\u5e94\u72b6\u6001\u7801", required=true)
    private Integer code;
    @ApiModelProperty(value="\u54cd\u5e94\u63d0\u793a\u6d88\u606f", required=true)
    private String message;
    @ApiModelProperty(value="\u54cd\u5e94\u65f6\u95f4\u6233", required=true)
    private String timestamp = TIMESTAMP;
    @ApiModelProperty(value="\u54cd\u5e94\u6570\u636e", required=false)
    private Object data;

    public ApiResult(Integer code, String message, Object data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static ApiResult result(boolean flag) {
        if (flag) {
            return ApiResult.ok();
        }
        return ApiResult.fail("");
    }

    public static ApiResult result(ApiCode apiCode, Object data) {
        return ApiResult.result(apiCode, null, data);
    }

    public static ApiResult result(ApiCode apiCode, String msg, Object data) {
        String message = apiCode.getMessage();
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            message = msg;
        }
        return new ApiResult(apiCode.getCode(), message, data);
    }

    public static ApiResult ok() {
        return ApiResult.ok(null);
    }

    public static ApiResult ok(Object data) {
        return ApiResult.result(ApiCode.OK, data);
    }

    public static ApiResult ok(String message, Object data) {
        return ApiResult.result(ApiCode.OK, message, data);
    }

    public static ApiResult ok(Integer code, String message, Object data) {
        return new ApiResult(code, message, data);
    }

    public static ApiResult okMap(String key, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        return ApiResult.ok(map);
    }

    public static ApiResult fail() {
        return ApiResult.fail(ApiCode.FAIL);
    }

    public static ApiResult fail(String message) {
        return ApiResult.result(ApiCode.FAIL, message, null);
    }

    public static ApiResult fail(ApiCode apiCode) {
        return ApiResult.result(apiCode, null);
    }

    public static ApiResult fail(ApiCode apiCode, Object data) {
        if (ApiCode.OK == apiCode) {
            throw new RuntimeException("\u5931\u8d25\u7ed3\u679c\u72b6\u6001\u7801\u4e0d\u80fd\u4e3a\uff1a" + apiCode.getCode());
        }
        return ApiResult.result(apiCode, data);
    }

    public static ApiResult fail(Integer code, String message) {
        return new ApiResult(code, message, null);
    }

    public static ApiResult fail(String message, Object data) {
        return new ApiResult(ApiCode.FAIL.getCode(), message, data);
    }

    public static ApiResult fail(Integer code, String message, Object data) {
        return new ApiResult(code, message, data);
    }

    public static ApiResult failMap(String key, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        return ApiResult.result(ApiCode.FAIL, map);
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String toString() {
        return "Result{code=" + this.code + ", message='" + this.message + "', timestamp='" + this.timestamp + "', data=" + this.data + "}";
    }
}

