/*
 * Decompiled with CFR 0.152.
 */
package club.javafamily.utils;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.imageio.ImageIO;
import sun.misc.BASE64Encoder;

public class EncryptUtil {
    public static final String KEY = "jntm";
    public static final String MD5 = "MD5";
    public static final String SHA1 = "SHA1";
    public static final String HmacMD5 = "HmacMD5";
    public static final String HmacSHA1 = "HmacSHA1";
    public static final String DES = "DES";
    public static final String AES = "AES";
    public static String charset = "utf-8";
    public static int keysizeDES = 0;
    public static int keysizeAES = 128;
    public static EncryptUtil me;

    private EncryptUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EncryptUtil getInstance() {
        if (me != null) return me;
        Class<EncryptUtil> clazz = EncryptUtil.class;
        synchronized (EncryptUtil.class) {
            if (me != null) return me;
            me = new EncryptUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return me;
        }
    }

    private String messageDigest(String res, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] resBytes = charset == null ? res.getBytes() : res.getBytes(charset);
            return this.base64(md.digest(resBytes));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String keyGeneratorMac(String res, String algorithm, String key) {
        try {
            SecretKey sk = null;
            if (key == null) {
                KeyGenerator kg = KeyGenerator.getInstance(algorithm);
                sk = kg.generateKey();
            } else {
                byte[] keyBytes = charset == null ? key.getBytes() : key.getBytes(charset);
                sk = new SecretKeySpec(keyBytes, algorithm);
            }
            Mac mac = Mac.getInstance(algorithm);
            mac.init(sk);
            byte[] result = mac.doFinal(res.getBytes());
            return this.base64(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String keyGeneratorES(String res, String algorithm, String key, int keysize, boolean isEncode) {
        try {
            byte[] keyBytes;
            KeyGenerator kg = KeyGenerator.getInstance(algorithm);
            if (keysize == 0) {
                keyBytes = charset == null ? key.getBytes() : key.getBytes(charset);
                SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
                random.setSeed(keyBytes);
                kg.init(random);
            } else if (key == null) {
                kg.init(keysize);
            } else {
                keyBytes = charset == null ? key.getBytes() : key.getBytes(charset);
                kg.init(keysize, new SecureRandom(keyBytes));
            }
            SecretKey sk = kg.generateKey();
            SecretKeySpec sks = new SecretKeySpec(sk.getEncoded(), algorithm);
            Cipher cipher = Cipher.getInstance(algorithm);
            if (isEncode) {
                cipher.init(1, sks);
                byte[] resBytes = charset == null ? res.getBytes() : res.getBytes(charset);
                return EncryptUtil.parseByte2HexStr(cipher.doFinal(resBytes));
            }
            cipher.init(2, sks);
            return new String(cipher.doFinal(EncryptUtil.parseHexStr2Byte(res)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String base64(byte[] res) {
        return Base64.encode(res);
    }

    public static String parseByte2HexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    public String MD5(String res) {
        return this.messageDigest(res, MD5);
    }

    public String MD5(String res, String key) {
        return this.keyGeneratorMac(res, HmacMD5, key);
    }

    public String SHA1(String res) {
        return this.messageDigest(res, SHA1);
    }

    public String SHA1(String res, String key) {
        return this.keyGeneratorMac(res, HmacSHA1, key);
    }

    public static String DESencode(String res, String key) {
        return EncryptUtil.keyGeneratorES(res, DES, key, keysizeDES, true);
    }

    public static String DESdecode(String res, String key) {
        return EncryptUtil.keyGeneratorES(res, DES, key, keysizeDES, false);
    }

    public String AESencode(String res, String key) {
        return EncryptUtil.keyGeneratorES(res, AES, key, keysizeAES, true);
    }

    public String AESdecode(String res, String key) {
        return EncryptUtil.keyGeneratorES(res, AES, key, keysizeAES, false);
    }

    public String XORencode(String res, String key) {
        byte[] bs = res.getBytes();
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = (byte)(bs[i] ^ key.hashCode());
        }
        return EncryptUtil.parseByte2HexStr(bs);
    }

    public String XORdecode(String res, String key) {
        byte[] bs = EncryptUtil.parseHexStr2Byte(res);
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = (byte)(bs[i] ^ key.hashCode());
        }
        return new String(bs);
    }

    public int XOR(int res, String key) {
        return res ^ key.hashCode();
    }

    public String Base64Encode(String res) {
        return Base64.encode(res.getBytes());
    }

    public String Base64Decode(String res) {
        return new String(Base64.decode(res));
    }

    public static String BufferedImageToBase64(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", baos);
        byte[] bytes = baos.toByteArray();
        BASE64Encoder encoder = new BASE64Encoder();
        String png_base64 = encoder.encodeBuffer(bytes).trim();
        png_base64 = png_base64.replaceAll("\n", "").replaceAll("\r", "");
        return "data:image/png;base64," + png_base64;
    }
}

