/*
 * Decompiled with CFR 0.152.
 */
package club.moonlink.tools.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class GenericBuilder<T> {
    private final Supplier<T> supplier;
    private List<Consumer<T>> consumers = new ArrayList<Consumer<T>>();

    public GenericBuilder(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public static <T> GenericBuilder<T> of(Supplier<T> instance) {
        return new GenericBuilder<T>(instance);
    }

    public <U> GenericBuilder<T> with(BiConsumer<T, U> consumer, U value) {
        this.consumers.add(instance -> consumer.accept(instance, value));
        return this;
    }

    public T build() {
        Object value = this.supplier.get();
        this.consumers.forEach(modifier -> modifier.accept(value));
        this.consumers.clear();
        return value;
    }
}

