/*
 * Decompiled with CFR 0.152.
 */
package club.psychose.library.ibo;

import club.psychose.library.ibo.datatypes.types.signed.Int16;
import club.psychose.library.ibo.datatypes.types.signed.Int32;
import club.psychose.library.ibo.datatypes.types.signed.Int64;
import club.psychose.library.ibo.datatypes.types.signed.Int8;
import club.psychose.library.ibo.datatypes.types.unsigned.UInt16;
import club.psychose.library.ibo.datatypes.types.unsigned.UInt32;
import club.psychose.library.ibo.datatypes.types.unsigned.UInt64;
import club.psychose.library.ibo.datatypes.types.unsigned.UInt8;
import club.psychose.library.ibo.exceptions.ClosedException;
import club.psychose.library.ibo.exceptions.OpenedException;
import club.psychose.library.ibo.exceptions.RangeOutOfBoundsException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;

public final class BinaryWriter {
    private ByteOrder byteOrder;
    private RandomAccessFile randomAccessFile;
    private boolean closed;
    private long offsetPosition;
    private boolean chunkPadding;
    private int chunkSize;
    private byte chunkPaddingByte;

    public BinaryWriter() {
        this.byteOrder = ByteOrder.nativeOrder();
        this.randomAccessFile = null;
        this.closed = true;
        this.offsetPosition = 0L;
        this.chunkPadding = false;
        this.chunkSize = 0;
        this.chunkPaddingByte = 0;
    }

    public BinaryWriter(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
        this.randomAccessFile = null;
        this.closed = true;
        this.offsetPosition = 0L;
        this.chunkPadding = false;
        this.chunkSize = 0;
        this.chunkPaddingByte = 0;
    }

    public void open(Path filePath, boolean overwrite) throws OpenedException, ClosedException, IOException {
        if (!this.isClosed()) {
            throw new OpenedException("The BinaryWriter is already opened!");
        }
        if (!Files.exists(filePath, new LinkOption[0]) || overwrite) {
            Path directoryPath = filePath.getParent();
            if (!Files.exists(directoryPath, new LinkOption[0])) {
                Files.createDirectories(directoryPath, new FileAttribute[0]);
            }
            Files.deleteIfExists(filePath);
            Files.createFile(filePath, new FileAttribute[0]);
        }
        this.randomAccessFile = new RandomAccessFile(filePath.toFile(), "rw");
        this.randomAccessFile.seek(0L);
        this.closed = false;
        this.offsetPosition = 0L;
        if (!overwrite) {
            this.setOffsetPosition(this.randomAccessFile.length());
        }
    }

    public void close() throws IOException {
        if (!this.isClosed()) {
            this.randomAccessFile.close();
            this.randomAccessFile = null;
            this.closed = true;
            this.offsetPosition = 0L;
        }
    }

    public void fill(byte fillWithByte, int length) throws ClosedException, IOException {
        if (this.isClosed()) {
            throw new ClosedException("The BinaryWriter is closed!");
        }
        this.fillOnly(fillWithByte, length);
        if (this.chunkPadding) {
            int paddingBytes = this.chunkSize - length % this.chunkSize;
            this.fillOnly(this.chunkPaddingByte, paddingBytes);
        }
    }

    public void fillOnly(byte fillWithByte, int length) throws ClosedException, IOException {
        if (this.isClosed()) {
            throw new ClosedException("The BinaryWriter is closed!");
        }
        byte[] fillBytes = new byte[length];
        Arrays.fill(fillBytes, fillWithByte);
        this.randomAccessFile.seek(this.offsetPosition);
        this.randomAccessFile.write(fillBytes, 0, length);
        this.skipOffsetPosition(length);
    }

    public void write(byte[] bytes) throws ClosedException, IOException {
        if (this.isClosed()) {
            throw new ClosedException("The BinaryWriter is closed!");
        }
        this.randomAccessFile.seek(this.offsetPosition);
        this.randomAccessFile.write(bytes, 0, bytes.length);
        this.skipOffsetPosition(bytes.length);
        if (this.chunkPadding) {
            int paddingBytes = this.chunkSize - bytes.length % this.chunkSize;
            this.fillOnly(this.chunkPaddingByte, paddingBytes);
        }
    }

    public void write(Int8 int8) throws ClosedException, IOException {
        this.write(int8.getAsBytes(this.byteOrder));
    }

    public void write(UInt8 uInt8) throws ClosedException, IOException, RangeOutOfBoundsException {
        this.write(uInt8.getAsBytes(this.byteOrder));
    }

    public void write(Int16 int16) throws ClosedException, IOException, RangeOutOfBoundsException {
        this.write(int16.getAsBytes(this.byteOrder));
    }

    public void write(UInt16 uInt16) throws ClosedException, IOException, RangeOutOfBoundsException {
        this.write(uInt16.getAsBytes(this.byteOrder));
    }

    public void write(Int32 int32) throws ClosedException, IOException, RangeOutOfBoundsException {
        this.write(int32.getAsBytes(this.byteOrder));
    }

    public void write(UInt32 uInt32) throws ClosedException, IOException, RangeOutOfBoundsException {
        this.write(uInt32.getAsBytes(this.byteOrder));
    }

    public void write(Int64 int64) throws ClosedException, IOException, RangeOutOfBoundsException {
        this.write(int64.getAsBytes(this.byteOrder));
    }

    public void write(UInt64 uInt64) throws ClosedException, IOException, RangeOutOfBoundsException {
        this.write(uInt64.getAsBytes(this.byteOrder));
    }

    public void write(float value) throws ClosedException, IOException {
        this.write(ByteBuffer.allocate(4).order(this.byteOrder).putFloat(value).array());
    }

    public void write(double value) throws ClosedException, IOException {
        this.write(ByteBuffer.allocate(8).order(this.byteOrder).putDouble(value).array());
    }

    public void write(String value) throws ClosedException, IOException {
        this.write(ByteBuffer.allocate(value.length()).order(this.byteOrder).put(value.getBytes()).array());
    }

    public void write(String value, Charset charset) throws ClosedException, IOException {
        this.write(ByteBuffer.allocate(value.length()).order(this.byteOrder).put(value.getBytes(charset)).array());
    }

    public void setOffsetPosition(long offsetPosition) throws ClosedException, IOException {
        if (this.isClosed()) {
            throw new ClosedException("The BinaryWriter is closed!");
        }
        this.offsetPosition = offsetPosition;
        this.randomAccessFile.seek(this.offsetPosition);
    }

    public void skipOffsetPosition(long length) throws ClosedException, IOException {
        if (this.isClosed()) {
            throw new ClosedException("The BinaryWriter is closed!");
        }
        this.setOffsetPosition(this.offsetPosition + length);
    }

    public void setByteOrder(ByteOrder value) {
        this.byteOrder = value;
    }

    public void enableChunkPadding(int chunkSize, byte paddingByte) {
        this.chunkPadding = true;
        this.chunkSize = chunkSize;
        this.chunkPaddingByte = paddingByte;
    }

    public void disableChunkPadding() {
        this.chunkPadding = false;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isChunkPaddingEnabled() {
        return this.chunkPadding;
    }

    public long getChunkSize() {
        return this.chunkSize;
    }

    public long getFileLength() throws ClosedException, IOException {
        if (this.isClosed()) {
            throw new ClosedException("The BinaryWriter is closed!");
        }
        return this.randomAccessFile.length();
    }

    public long getOffsetPosition() throws ClosedException {
        if (this.isClosed()) {
            throw new ClosedException("The BinaryWriter is closed!");
        }
        return this.offsetPosition;
    }
}

