/*
 * Decompiled with CFR 0.152.
 */
package club.psychose.library.ibo;

import club.psychose.library.ibo.datatypes.types.signed.Int16;
import club.psychose.library.ibo.datatypes.types.signed.Int32;
import club.psychose.library.ibo.datatypes.types.signed.Int64;
import club.psychose.library.ibo.datatypes.types.signed.Int8;
import club.psychose.library.ibo.datatypes.types.unsigned.UInt16;
import club.psychose.library.ibo.datatypes.types.unsigned.UInt32;
import club.psychose.library.ibo.datatypes.types.unsigned.UInt64;
import club.psychose.library.ibo.datatypes.types.unsigned.UInt8;
import club.psychose.library.ibo.exceptions.ClosedException;
import club.psychose.library.ibo.exceptions.OpenedException;
import club.psychose.library.ibo.exceptions.RangeOutOfBoundsException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public final class FileBinaryReader {
    private final int chunkLength;
    private ByteBuffer byteBuffer;
    private ByteOrder byteOrder;
    private boolean closed;
    private Path filePath;
    private int currentChunk;
    private int chunkOffsetPosition;
    private long offsetPosition;

    public FileBinaryReader(int chunkLength) throws RangeOutOfBoundsException {
        if (chunkLength <= 0) {
            throw new RangeOutOfBoundsException("The chunk length can't be negative or 0!");
        }
        this.chunkLength = chunkLength;
        this.byteBuffer = null;
        this.byteOrder = ByteOrder.nativeOrder();
        this.closed = true;
        this.filePath = null;
        this.currentChunk = -1;
        this.chunkOffsetPosition = -1;
        this.offsetPosition = -1L;
    }

    public FileBinaryReader(int chunkLength, ByteOrder byteOrder) throws RangeOutOfBoundsException {
        if (chunkLength <= 0) {
            throw new RangeOutOfBoundsException("The chunk length can't be negative or 0!");
        }
        this.chunkLength = chunkLength;
        this.byteBuffer = null;
        this.byteOrder = byteOrder;
        this.closed = true;
        this.filePath = null;
        this.currentChunk = -1;
        this.chunkOffsetPosition = -1;
        this.offsetPosition = -1L;
    }

    public void open(Path filePath) throws OpenedException, ClosedException, IOException, RangeOutOfBoundsException {
        this.open(filePath, 0);
    }

    public void open(Path filePath, int startOffsetPosition) throws OpenedException, ClosedException, IOException, RangeOutOfBoundsException {
        if (!this.isClosed()) {
            throw new OpenedException("The FileBinaryReader is already opened! - Call close() before using open() again!");
        }
        if (!Files.exists(filePath, new LinkOption[0])) {
            throw new FileNotFoundException("The file \"" + filePath + "\" does not exists!");
        }
        if (startOffsetPosition < 0 || (long)startOffsetPosition > filePath.toFile().length()) {
            throw new RangeOutOfBoundsException("The startOffsetPosition is out of bounds!");
        }
        this.closed = false;
        this.filePath = filePath;
        this.currentChunk = 0;
        this.chunkOffsetPosition = 0;
        this.offsetPosition = 0L;
        this.setOffsetPosition(startOffsetPosition);
    }

    public void close() {
        if (!this.isClosed()) {
            this.byteBuffer = null;
            this.closed = true;
            this.filePath = null;
            this.currentChunk = -1;
            this.chunkOffsetPosition = -1;
            this.offsetPosition = -1L;
        }
    }

    public byte[] readBytes(int length) throws ClosedException, IOException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        if (length <= 0 || this.offsetPosition + (long)length > this.getFileLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds or the length is negative or 0!");
        }
        long newOffsetPosition = this.offsetPosition + (long)length;
        if (this.currentChunk != this.getChunk(newOffsetPosition)) {
            this.readChunk(this.offsetPosition, length);
        }
        long newChunkOffsetPosition = this.chunkOffsetPosition + length;
        if ((long)this.byteBuffer.position() < newChunkOffsetPosition) {
            this.readChunk(this.offsetPosition, length);
        }
        byte[] bytes = new byte[length];
        for (int index = 0; index < length; ++index) {
            bytes[index] = this.byteBuffer.get(this.chunkOffsetPosition + index);
        }
        this.setOffsetPosition(newOffsetPosition);
        return bytes;
    }

    public Int8 readInt8() throws ClosedException, IOException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        if (this.offsetPosition + (long)Int8.getByteLength() > this.getFileLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds!");
        }
        long newOffsetPosition = this.offsetPosition + (long)Int8.getByteLength();
        if (this.currentChunk != this.getChunk(newOffsetPosition)) {
            this.readChunk(this.offsetPosition, Int8.getByteLength());
        }
        Int8 int8 = new Int8(this.byteBuffer.get());
        this.setOffsetPosition(newOffsetPosition);
        return int8;
    }

    public UInt8 readUInt8() throws ClosedException, IOException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        if (this.offsetPosition + (long)UInt8.getByteLength() > this.getFileLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds!");
        }
        long newOffsetPosition = this.offsetPosition + (long)UInt8.getByteLength();
        if (this.currentChunk != this.getChunk(newOffsetPosition)) {
            this.readChunk(this.offsetPosition, UInt8.getByteLength());
        }
        UInt8 uInt8 = new UInt8(this.byteBuffer.get());
        this.setOffsetPosition(newOffsetPosition);
        return uInt8;
    }

    public Int16 readInt16() throws ClosedException, IOException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        if (this.offsetPosition + (long)Int16.getByteLength() > this.getFileLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds!");
        }
        long newOffsetPosition = this.offsetPosition + (long)Int16.getByteLength();
        if (this.currentChunk != this.getChunk(newOffsetPosition)) {
            this.readChunk(this.offsetPosition, Int16.getByteLength());
        }
        return new Int16(this.readBytes(Int16.getByteLength()), this.byteOrder);
    }

    public UInt16 readUInt16() throws ClosedException, IOException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        if (this.offsetPosition + (long)UInt16.getByteLength() > this.getFileLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds!");
        }
        long newOffsetPosition = this.offsetPosition + (long)UInt16.getByteLength();
        if (this.currentChunk != this.getChunk(newOffsetPosition)) {
            this.readChunk(this.offsetPosition, UInt16.getByteLength());
        }
        return new UInt16(this.readBytes(UInt16.getByteLength()), this.byteOrder);
    }

    public Int32 readInt32() throws ClosedException, IOException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        if (this.offsetPosition + (long)Int32.getByteLength() > this.getFileLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds!");
        }
        long newOffsetPosition = this.offsetPosition + (long)Int32.getByteLength();
        if (this.currentChunk != this.getChunk(newOffsetPosition)) {
            this.readChunk(this.offsetPosition, Int32.getByteLength());
        }
        return new Int32(this.readBytes(Int32.getByteLength()), this.byteOrder);
    }

    public UInt32 readUInt32() throws ClosedException, IOException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        if (this.offsetPosition + (long)UInt32.getByteLength() > this.getFileLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds!");
        }
        long newOffsetPosition = this.offsetPosition + (long)UInt32.getByteLength();
        if (this.currentChunk != this.getChunk(newOffsetPosition)) {
            this.readChunk(this.offsetPosition, UInt32.getByteLength());
        }
        return new UInt32(this.readBytes(UInt32.getByteLength()), this.byteOrder);
    }

    public Int64 readInt64() throws ClosedException, IOException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        if (this.offsetPosition + (long)Int64.getByteLength() > this.getFileLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds!");
        }
        long newOffsetPosition = this.offsetPosition + (long)Int64.getByteLength();
        if (this.currentChunk != this.getChunk(newOffsetPosition)) {
            this.readChunk(this.offsetPosition, Int64.getByteLength());
        }
        return new Int64(this.readBytes(Int64.getByteLength()), this.byteOrder);
    }

    public UInt64 readUInt64() throws ClosedException, IOException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        if (this.offsetPosition + (long)UInt64.getByteLength() > this.getFileLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds!");
        }
        long newOffsetPosition = this.offsetPosition + (long)UInt64.getByteLength();
        if (this.currentChunk != this.getChunk(newOffsetPosition)) {
            this.readChunk(this.offsetPosition, UInt64.getByteLength());
        }
        return new UInt64(this.readBytes(UInt64.getByteLength()), this.byteOrder);
    }

    public float readFloat() throws ClosedException, IOException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        if (this.offsetPosition + 4L > this.getFileLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds!");
        }
        long newOffsetPosition = this.offsetPosition + 4L;
        if (this.currentChunk != this.getChunk(newOffsetPosition)) {
            this.readChunk(this.offsetPosition, 4);
        }
        float binaryFloat = this.byteBuffer.getFloat();
        this.setOffsetPosition(newOffsetPosition);
        return binaryFloat;
    }

    public double readDouble() throws ClosedException, IOException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        if (this.offsetPosition + 8L > this.getFileLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds!");
        }
        long newOffsetPosition = this.offsetPosition + 8L;
        if (this.currentChunk != this.getChunk(newOffsetPosition)) {
            this.readChunk(this.offsetPosition, 8);
        }
        double binaryDouble = this.byteBuffer.getDouble();
        this.setOffsetPosition(newOffsetPosition);
        return binaryDouble;
    }

    public String readString(int length) throws ClosedException, IOException, RangeOutOfBoundsException {
        return this.readString(length, StandardCharsets.UTF_8);
    }

    public String readString(int length, Charset charset) throws ClosedException, IOException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        if (length < 0 || this.offsetPosition + (long)length > this.getFileLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds or the length is negative or 0!");
        }
        long newOffsetPosition = this.offsetPosition + (long)length;
        if (this.currentChunk != this.getChunk(newOffsetPosition)) {
            this.readChunk(this.offsetPosition, length);
        }
        byte[] stringBytes = this.readBytes(length);
        return new String(stringBytes, charset);
    }

    public void readChunkIntoTheMemory(int chunkNumber) throws ClosedException, IOException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        this.readChunk((long)chunkNumber * (long)this.chunkLength, this.chunkLength);
    }

    public void setOffsetPosition(long offsetPosition) throws ClosedException, IOException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        if (offsetPosition < 0L || offsetPosition > this.getFileLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds!");
        }
        if (this.offsetPosition == 0L || this.currentChunk != this.getChunk(offsetPosition)) {
            this.readChunkIntoTheMemory(this.getChunk(offsetPosition));
        }
        this.offsetPosition = offsetPosition;
        this.currentChunk = this.getChunk(offsetPosition);
        this.chunkOffsetPosition = this.getChunkOffsetPosition(offsetPosition);
        this.checkChunkState();
        this.byteBuffer.position(this.chunkOffsetPosition);
    }

    public void skipOffsetPosition(long length) throws ClosedException, IOException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        this.setOffsetPosition(this.offsetPosition + length);
    }

    private void checkChunkState() throws ClosedException, IOException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        if (this.byteBuffer.capacity() != this.chunkLength) {
            long remainingBytes = this.getRemainingBytes();
            if (remainingBytes - (long)this.chunkOffsetPosition >= (long)this.chunkLength) {
                this.readChunkIntoTheMemory(this.getCurrentChunk());
            } else if ((long)this.chunkLength < remainingBytes) {
                this.readChunkIntoTheMemory(this.getCurrentChunk());
            } else {
                this.readChunk(this.offsetPosition, (int)remainingBytes);
            }
        }
    }

    private void readChunk(long offsetPosition, int readLength) throws ClosedException, IOException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        long newOffsetPosition = offsetPosition + (long)readLength;
        if (newOffsetPosition > this.getFileLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds!");
        }
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.filePath.toFile(), "r");){
            byte[] buffer = new byte[readLength];
            randomAccessFile.seek(offsetPosition);
            randomAccessFile.read(buffer, 0, readLength);
            randomAccessFile.close();
            this.byteBuffer = ByteBuffer.wrap(buffer).order(this.byteOrder);
            this.byteBuffer.position(0);
            this.chunkOffsetPosition = 0;
            if (this.currentChunk != this.getChunk(newOffsetPosition)) {
                this.currentChunk = this.getChunk(newOffsetPosition);
            }
        }
    }

    public void setByteOrder(ByteOrder value) {
        this.byteOrder = value;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public int getChunk(long offsetPosition) throws ClosedException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        if (offsetPosition == 0L) {
            offsetPosition = 1L;
        }
        return (int)(offsetPosition / (long)this.chunkLength);
    }

    public int getChunkOffsetPosition() throws ClosedException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        return this.chunkOffsetPosition;
    }

    public int getChunkOffsetPosition(long offsetPosition) throws ClosedException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        return (int)(offsetPosition % (long)this.chunkLength);
    }

    public int getCurrentChunk() throws ClosedException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        return this.currentChunk;
    }

    public long getFileOffsetPosition() throws ClosedException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        return this.offsetPosition;
    }

    public long getFileLength() throws ClosedException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        return this.filePath.toFile().length();
    }

    public long getRemainingBytes() throws ClosedException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        return this.getFileLength() - this.offsetPosition;
    }

    public long getRemainingChunkBytes() throws ClosedException {
        if (this.isClosed()) {
            throw new ClosedException("The FileBinaryReader is closed!");
        }
        return this.chunkLength - this.getChunkOffsetPosition(this.offsetPosition);
    }
}

