/*
 * Decompiled with CFR 0.152.
 */
package club.psychose.library.ibo;

import club.psychose.library.ibo.datatypes.types.signed.Int16;
import club.psychose.library.ibo.datatypes.types.signed.Int32;
import club.psychose.library.ibo.datatypes.types.signed.Int64;
import club.psychose.library.ibo.datatypes.types.signed.Int8;
import club.psychose.library.ibo.datatypes.types.unsigned.UInt16;
import club.psychose.library.ibo.datatypes.types.unsigned.UInt32;
import club.psychose.library.ibo.datatypes.types.unsigned.UInt64;
import club.psychose.library.ibo.datatypes.types.unsigned.UInt8;
import club.psychose.library.ibo.exceptions.ClosedException;
import club.psychose.library.ibo.exceptions.OpenedException;
import club.psychose.library.ibo.exceptions.RangeOutOfBoundsException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.stream.IntStream;

public final class MemoryBinaryReader {
    private ByteBuffer byteBuffer = null;
    private ByteOrder byteOrder;
    private boolean closed;
    private int offsetPosition;

    public MemoryBinaryReader() {
        this.byteOrder = ByteOrder.nativeOrder();
        this.closed = true;
        this.offsetPosition = -1;
    }

    public MemoryBinaryReader(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
        this.closed = true;
        this.offsetPosition = -1;
    }

    public void open(byte[] bytes) throws OpenedException, ClosedException, RangeOutOfBoundsException {
        this.open(bytes, 0);
    }

    public void open(byte[] bytes, int startOffsetPosition) throws OpenedException, ClosedException, RangeOutOfBoundsException {
        if (!this.isClosed()) {
            throw new OpenedException("The FileBinaryReader is already opened! - Call close() before using open() again!");
        }
        if (startOffsetPosition < 0 || startOffsetPosition > bytes.length) {
            throw new RangeOutOfBoundsException("The startOffsetPosition is out of bounds!");
        }
        this.byteBuffer = ByteBuffer.wrap(bytes).order(this.byteOrder);
        this.closed = false;
        this.offsetPosition = 0;
        this.setOffsetPosition(startOffsetPosition);
    }

    public void close() {
        if (!this.isClosed()) {
            this.byteBuffer = null;
            this.closed = true;
            this.offsetPosition = -1;
        }
    }

    public byte[] readBytes(int length) throws ClosedException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The MemoryBinaryReader is closed!");
        }
        if (length <= 0 || this.offsetPosition + length > this.getBinaryLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds or the length is negative or 0!");
        }
        int newOffsetPosition = this.offsetPosition + length;
        byte[] bytes = new byte[length];
        IntStream.range(this.offsetPosition, newOffsetPosition).forEachOrdered(byteIndex -> {
            int index = byteIndex - this.offsetPosition;
            bytes[index] = this.byteBuffer.get(byteIndex);
        });
        this.setOffsetPosition(newOffsetPosition);
        return bytes;
    }

    public Int8 readInt8() throws ClosedException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The MemoryBinaryReader is closed!");
        }
        if (this.offsetPosition + Int8.getByteLength() > this.getBinaryLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds!");
        }
        int newOffsetPosition = this.offsetPosition + Int8.getByteLength();
        Int8 int8 = new Int8(this.byteBuffer.get());
        this.setOffsetPosition(newOffsetPosition);
        return int8;
    }

    public UInt8 readUInt8() throws ClosedException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The MemoryBinaryReader is closed!");
        }
        if (this.offsetPosition + UInt8.getByteLength() > this.getBinaryLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds!");
        }
        int newOffsetPosition = this.offsetPosition + UInt8.getByteLength();
        UInt8 uInt8 = new UInt8(this.byteBuffer.get());
        this.setOffsetPosition(newOffsetPosition);
        return uInt8;
    }

    public Int16 readInt16() throws ClosedException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The MemoryBinaryReader is closed!");
        }
        if (this.offsetPosition + Int16.getByteLength() > this.getBinaryLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds!");
        }
        return new Int16(this.readBytes(Int16.getByteLength()), this.byteOrder);
    }

    public UInt16 readUInt16() throws ClosedException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The MemoryBinaryReader is closed!");
        }
        if (this.offsetPosition + UInt16.getByteLength() > this.getBinaryLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds!");
        }
        return new UInt16(this.readBytes(UInt16.getByteLength()), this.byteOrder);
    }

    public Int32 readInt32() throws ClosedException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The MemoryBinaryReader is closed!");
        }
        if (this.offsetPosition + Int32.getByteLength() > this.getBinaryLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds!");
        }
        return new Int32(this.readBytes(Int32.getByteLength()), this.byteOrder);
    }

    public UInt32 readUInt32() throws ClosedException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The MemoryBinaryReader is closed!");
        }
        if (this.offsetPosition + UInt32.getByteLength() > this.getBinaryLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds!");
        }
        return new UInt32(this.readBytes(UInt32.getByteLength()), this.byteOrder);
    }

    public Int64 readInt64() throws ClosedException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The MemoryBinaryReader is closed!");
        }
        if (this.offsetPosition + Int64.getByteLength() > this.getBinaryLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds!");
        }
        return new Int64(this.readBytes(Int64.getByteLength()), this.byteOrder);
    }

    public UInt64 readUInt64() throws ClosedException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The MemoryBinaryReader is closed!");
        }
        if (this.offsetPosition + UInt64.getByteLength() > this.getBinaryLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds!");
        }
        return new UInt64(this.readBytes(UInt64.getByteLength()), this.byteOrder);
    }

    public float readFloat() throws ClosedException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The MemoryBinaryReader is closed!");
        }
        int newOffsetPosition = this.offsetPosition + 4;
        if (newOffsetPosition > this.getBinaryLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds!");
        }
        float binaryFloat = this.byteBuffer.getFloat();
        this.setOffsetPosition(newOffsetPosition);
        return binaryFloat;
    }

    public double readDouble() throws ClosedException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The MemoryBinaryReader is closed!");
        }
        int newOffsetPosition = this.offsetPosition + 8;
        if (this.offsetPosition + 8 > this.getBinaryLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds!");
        }
        double binaryDouble = this.byteBuffer.getDouble();
        this.setOffsetPosition(newOffsetPosition);
        return binaryDouble;
    }

    public String readString(int length) throws ClosedException, RangeOutOfBoundsException {
        return this.readString(length, StandardCharsets.UTF_8);
    }

    public String readString(int length, Charset charset) throws ClosedException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The MemoryBinaryReader is closed!");
        }
        int newOffsetPosition = this.offsetPosition + length;
        if (length < 0 || newOffsetPosition > this.getBinaryLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds or the length is negative or 0!");
        }
        byte[] stringBytes = this.readBytes(length);
        this.setOffsetPosition(newOffsetPosition);
        return new String(stringBytes, charset);
    }

    public void setOffsetPosition(int offsetPosition) throws ClosedException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The MemoryBinaryReader is closed!");
        }
        if (offsetPosition < 0 || offsetPosition > this.getBinaryLength()) {
            throw new RangeOutOfBoundsException("The offset position is out of bounds!");
        }
        this.offsetPosition = offsetPosition;
        this.byteBuffer.position(offsetPosition);
    }

    public void skipOffsetPosition(int length) throws ClosedException, RangeOutOfBoundsException {
        if (this.isClosed()) {
            throw new ClosedException("The MemoryBinaryReader is closed!");
        }
        this.setOffsetPosition(this.offsetPosition + length);
    }

    public void setByteOrder(ByteOrder value) {
        this.byteOrder = value;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public int getOffsetPosition() throws ClosedException {
        if (this.isClosed()) {
            throw new ClosedException("The MemoryBinaryReader is closed!");
        }
        return this.offsetPosition;
    }

    public int getBinaryLength() throws ClosedException {
        if (this.isClosed()) {
            throw new ClosedException("The MemoryBinaryReader is closed!");
        }
        return this.byteBuffer.capacity();
    }

    public int getRemainingBytes() throws ClosedException {
        if (this.isClosed()) {
            throw new ClosedException("The MemoryBinaryReader is closed!");
        }
        return this.byteBuffer.remaining();
    }
}

