/*
 * Decompiled with CFR 0.152.
 */
package club.psychose.library.ibo.datatypes;

import club.psychose.library.ibo.enums.HEXFormat;
import club.psychose.library.ibo.exceptions.RangeOutOfBoundsException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.IntStream;

public abstract class IBODataType<DataType extends Number> {
    protected DataType dataObject;

    public IBODataType(DataType dataObject) throws RangeOutOfBoundsException {
        this.setValue(dataObject);
    }

    public abstract void setValue(DataType var1) throws RangeOutOfBoundsException;

    protected byte[] extractBytes(byte[] bytes, ByteOrder byteOrder, int extractLength, int paddedBytesLength, boolean isValueNegative) throws RangeOutOfBoundsException {
        if (bytes.length < extractLength) {
            throw new RangeOutOfBoundsException("Invalid extraction length provided for byte extraction!");
        }
        if (extractLength < paddedBytesLength) {
            throw new RangeOutOfBoundsException("Invalid padding byte length provided for byte extraction!");
        }
        ByteBuffer byteBuffer = byteOrder != null ? ByteBuffer.allocate(extractLength).order(byteOrder) : ByteBuffer.allocate(extractLength);
        int bytesFound = 0;
        int paddingCount = 0;
        boolean paddingFound = false;
        boolean wasLastByteIndicatedAsPadding = false;
        for (byte extractedByte : bytes) {
            if (bytesFound == extractLength) break;
            if (!paddingFound) {
                boolean indicatePaddingUsage;
                boolean bl = isValueNegative ? Integer.toHexString(extractedByte & 0xFF).equalsIgnoreCase("FF") : (indicatePaddingUsage = extractedByte == 0);
                if (indicatePaddingUsage) {
                    if ((paddingCount = (int)((short)(paddingCount + 1))) == paddedBytesLength) {
                        paddingFound = true;
                        continue;
                    }
                    wasLastByteIndicatedAsPadding = true;
                    continue;
                }
                paddingCount = 0;
                if (wasLastByteIndicatedAsPadding) {
                    if (!isValueNegative) {
                        byteBuffer.put((byte)0);
                    } else {
                        byteBuffer.put((byte)-1);
                    }
                    wasLastByteIndicatedAsPadding = false;
                }
            }
            byteBuffer.put(extractedByte);
            bytesFound = (short)(bytesFound + 1);
        }
        return byteBuffer.array();
    }

    protected byte[] getBytesAsBigEndianByteOrder(byte[] bytes, ByteOrder byteOrder) {
        if (byteOrder == null) {
            byteOrder = ByteOrder.nativeOrder();
        }
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            ArrayList<Byte> byteArrayList = new ArrayList<Byte>();
            byte[] byArray = bytes;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                Byte arrayByte = byArray[i];
                byteArrayList.add(arrayByte);
            }
            Collections.reverse(byteArrayList);
            IntStream.range(0, bytes.length).forEachOrdered(index -> {
                bytes[index] = (Byte)byteArrayList.get(index);
            });
        }
        return bytes;
    }

    public DataType getValue() {
        return this.dataObject;
    }

    public byte[] getAsBytes() throws RangeOutOfBoundsException {
        return this.getAsBytes(null);
    }

    public abstract byte[] getAsBytes(ByteOrder var1) throws RangeOutOfBoundsException;

    public int hashCode() {
        return this.dataObject.hashCode();
    }

    public String getAsString() {
        return String.valueOf(this.dataObject);
    }

    public String getAsHEXString(HEXFormat hexFormat) throws RangeOutOfBoundsException {
        return this.getAsHEXString(hexFormat, null);
    }

    public String getAsHEXString(HEXFormat hexFormat, ByteOrder byteOrder) throws RangeOutOfBoundsException {
        StringBuilder hexStringBuilder = new StringBuilder();
        String format = hexFormat == HEXFormat.UPPERCASE ? "%02X" : "%02x";
        for (byte byteValue : this.getAsBytes(byteOrder)) {
            hexStringBuilder.append(String.format(format, byteValue));
        }
        return hexStringBuilder.toString();
    }
}

