/*
 * Decompiled with CFR 0.152.
 */
package club.psychose.library.ibo.datatypes.types.signed;

import club.psychose.library.ibo.datatypes.IBODataType;
import club.psychose.library.ibo.exceptions.RangeOutOfBoundsException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;

public final class Int16
extends IBODataType<Integer> {
    public Int16(byte[] dataBytes) throws RangeOutOfBoundsException {
        super(Integer.valueOf(ByteBuffer.wrap(dataBytes, 0, 2).getShort()));
    }

    public Int16(byte[] dataBytes, ByteOrder byteOrder) throws RangeOutOfBoundsException {
        super(Integer.valueOf(ByteBuffer.wrap(dataBytes, 0, 2).order(byteOrder).getShort()));
    }

    public Int16(byte value) throws RangeOutOfBoundsException {
        super(Integer.valueOf(value));
    }

    public Int16(short value) throws RangeOutOfBoundsException {
        super(Integer.valueOf(value));
    }

    public Int16(int value) throws RangeOutOfBoundsException {
        super(value);
    }

    public Int16(long value) throws RangeOutOfBoundsException {
        super((int)value);
    }

    public Int16(float value) throws RangeOutOfBoundsException {
        super((int)value);
    }

    public Int16(double value) throws RangeOutOfBoundsException {
        super((int)value);
    }

    public Int16(BigInteger value) throws RangeOutOfBoundsException {
        super(value.intValue());
    }

    public Int16(String value) throws RangeOutOfBoundsException {
        super(Integer.parseInt(value));
    }

    @Override
    public void setValue(byte value) throws RangeOutOfBoundsException {
        if (value < Int16.getMinimumValue() || value > Int16.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the Int16 data type is out of bounds!");
        }
        this.dataObject = (int)value;
    }

    @Override
    public void setValue(short value) throws RangeOutOfBoundsException {
        if (value < Int16.getMinimumValue() || value > Int16.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the Int16 data type is out of bounds!");
        }
        this.dataObject = (int)value;
    }

    @Override
    public void setValue(Integer value) throws RangeOutOfBoundsException {
        this.setValue((int)value);
    }

    @Override
    public void setValue(int value) throws RangeOutOfBoundsException {
        if (value < Int16.getMinimumValue() || value > Int16.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the Int16 data type is out of bounds!");
        }
        this.dataObject = value;
    }

    @Override
    public void setValue(long value) throws RangeOutOfBoundsException {
        if (value < (long)Int16.getMinimumValue() || value > (long)Int16.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the Int16 data type is out of bounds!");
        }
        this.dataObject = (int)value;
    }

    @Override
    public void setValue(float value) throws RangeOutOfBoundsException {
        if (!(value >= (float)Int16.getMinimumValue()) || !(value <= (float)Int16.getMaximumValue())) {
            throw new RangeOutOfBoundsException("The value for the Int16 data type is out of bounds!");
        }
        this.dataObject = (int)value;
    }

    @Override
    public void setValue(double value) throws RangeOutOfBoundsException {
        if (!(value >= (double)Int16.getMinimumValue()) || !(value <= (double)Int16.getMaximumValue())) {
            throw new RangeOutOfBoundsException("The value for the Int16 data type is out of bounds!");
        }
        this.dataObject = (int)value;
    }

    @Override
    public void setValue(BigInteger value) throws RangeOutOfBoundsException {
        BigInteger convertedMinimumValue = BigInteger.valueOf(Int16.getMinimumValue());
        BigInteger convertedMaximumValue = BigInteger.valueOf(Int16.getMaximumValue());
        if (value.compareTo(convertedMinimumValue) <= 0 && !value.equals(convertedMinimumValue) || value.compareTo(convertedMaximumValue) >= 0 && !value.equals(convertedMaximumValue)) {
            throw new RangeOutOfBoundsException("The value for the Int16 data type is out of bounds!");
        }
        this.dataObject = value.intValue();
    }

    @Override
    public void setValue(String value) throws RangeOutOfBoundsException {
        int convertedValue = Integer.parseInt(value);
        if (convertedValue < Int16.getMinimumValue() || convertedValue > Int16.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the Int16 data type is out of bounds!");
        }
        this.dataObject = convertedValue;
    }

    @Override
    public byte[] getAsBytes(ByteOrder byteOrder) throws RangeOutOfBoundsException {
        byte[] integerBytes = byteOrder != null ? ByteBuffer.allocate(4).order(byteOrder).putInt((Integer)this.dataObject).array() : ByteBuffer.allocate(4).putInt((Integer)this.dataObject).array();
        boolean isValueNegative = (Integer)this.dataObject < 0;
        return this.extractBytes(integerBytes, byteOrder, 2, 2, isValueNegative);
    }

    public boolean equals(Int16 int16) {
        return Objects.equals(this.dataObject, int16.getValue());
    }

    public static short getByteLength() {
        return 2;
    }

    public static short getMinimumValue() {
        return Short.MIN_VALUE;
    }

    public static short getMaximumValue() {
        return Short.MAX_VALUE;
    }
}

