/*
 * Decompiled with CFR 0.152.
 */
package club.psychose.library.ibo.datatypes.types.signed;

import club.psychose.library.ibo.datatypes.IBODataType;
import club.psychose.library.ibo.exceptions.RangeOutOfBoundsException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;

public final class Int32
extends IBODataType<Long> {
    public Int32(byte[] dataBytes) throws RangeOutOfBoundsException {
        super(Long.valueOf(ByteBuffer.wrap(dataBytes, 0, 4).getInt()));
    }

    public Int32(byte[] dataBytes, ByteOrder byteOrder) throws RangeOutOfBoundsException {
        super(Long.valueOf(ByteBuffer.wrap(dataBytes, 0, 4).order(byteOrder).getInt()));
    }

    public Int32(byte value) throws RangeOutOfBoundsException {
        super(Long.valueOf(value));
    }

    public Int32(short value) throws RangeOutOfBoundsException {
        super(Long.valueOf(value));
    }

    public Int32(int value) throws RangeOutOfBoundsException {
        super(Long.valueOf(value));
    }

    public Int32(long value) throws RangeOutOfBoundsException {
        super(value);
    }

    public Int32(float value) throws RangeOutOfBoundsException {
        super((long)value);
    }

    public Int32(double value) throws RangeOutOfBoundsException {
        super((long)value);
    }

    public Int32(BigInteger value) throws RangeOutOfBoundsException {
        super(value.longValue());
    }

    public Int32(String value) throws RangeOutOfBoundsException {
        super(Long.parseLong(value));
    }

    @Override
    public void setValue(byte value) throws RangeOutOfBoundsException {
        if ((long)value < Int32.getMinimumValue() || (long)value > Int32.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the Int32 data type is out of bounds!");
        }
        this.dataObject = (long)value;
    }

    @Override
    public void setValue(short value) throws RangeOutOfBoundsException {
        if ((long)value < Int32.getMinimumValue() || (long)value > Int32.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the Int32 data type is out of bounds!");
        }
        this.dataObject = (long)value;
    }

    @Override
    public void setValue(int value) throws RangeOutOfBoundsException {
        if ((long)value < Int32.getMinimumValue() || (long)value > Int32.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the Int32 data type is out of bounds!");
        }
        this.dataObject = (long)value;
    }

    @Override
    public void setValue(Long value) throws RangeOutOfBoundsException {
        this.setValue((long)value);
    }

    @Override
    public void setValue(long value) throws RangeOutOfBoundsException {
        if (value < Int32.getMinimumValue() || value > Int32.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the Int32 data type is out of bounds!");
        }
        this.dataObject = value;
    }

    @Override
    public void setValue(float value) throws RangeOutOfBoundsException {
        if (!(value >= (float)Int32.getMinimumValue()) || !(value <= (float)Int32.getMaximumValue())) {
            throw new RangeOutOfBoundsException("The value for the Int32 data type is out of bounds!");
        }
        this.dataObject = (long)value;
    }

    @Override
    public void setValue(double value) throws RangeOutOfBoundsException {
        if (!(value >= (double)Int32.getMinimumValue()) || !(value <= (double)Int32.getMaximumValue())) {
            throw new RangeOutOfBoundsException("The value for the Int32 data type is out of bounds!");
        }
        this.dataObject = (long)value;
    }

    @Override
    public void setValue(BigInteger value) throws RangeOutOfBoundsException {
        BigInteger convertedMinimumValue = BigInteger.valueOf(Int32.getMinimumValue());
        BigInteger convertedMaximumValue = BigInteger.valueOf(Int32.getMaximumValue());
        if (value.compareTo(convertedMinimumValue) <= 0 && !value.equals(convertedMinimumValue) || value.compareTo(convertedMaximumValue) >= 0 && !value.equals(convertedMaximumValue)) {
            throw new RangeOutOfBoundsException("The value for the Int32 data type is out of bounds!");
        }
        this.dataObject = value.longValue();
    }

    @Override
    public void setValue(String value) throws RangeOutOfBoundsException {
        long convertedValue = Long.parseLong(value);
        if (convertedValue < Int32.getMinimumValue() || convertedValue > Int32.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the Int32 data type is out of bounds!");
        }
        this.dataObject = convertedValue;
    }

    @Override
    public byte[] getAsBytes(ByteOrder byteOrder) throws RangeOutOfBoundsException {
        byte[] longBytes = byteOrder != null ? ByteBuffer.allocate(8).order(byteOrder).putLong((Long)this.dataObject).array() : ByteBuffer.allocate(8).putLong((Long)this.dataObject).array();
        boolean isValueNegative = (Long)this.dataObject < 0L;
        return this.extractBytes(longBytes, byteOrder, 4, 4, isValueNegative);
    }

    public boolean equals(Int32 int32) {
        return Objects.equals(this.dataObject, int32.getValue());
    }

    public static short getByteLength() {
        return 4;
    }

    public static long getMinimumValue() {
        return Integer.MIN_VALUE;
    }

    public static long getMaximumValue() {
        return Integer.MAX_VALUE;
    }
}

