/*
 * Decompiled with CFR 0.152.
 */
package club.psychose.library.ibo.datatypes.types.signed;

import club.psychose.library.ibo.datatypes.IBODataType;
import club.psychose.library.ibo.exceptions.RangeOutOfBoundsException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import java.util.stream.IntStream;

public final class Int64
extends IBODataType<BigInteger> {
    public Int64(byte[] dataBytes) throws RangeOutOfBoundsException {
        super(BigInteger.valueOf(0L));
        this.setValue(new BigInteger(ByteBuffer.wrap(this.getBytesAsBigEndianByteOrder(dataBytes, null), 0, 8).array()));
    }

    public Int64(byte[] dataBytes, ByteOrder byteOrder) throws RangeOutOfBoundsException {
        super(BigInteger.valueOf(0L));
        this.setValue(new BigInteger(ByteBuffer.wrap(this.getBytesAsBigEndianByteOrder(dataBytes, byteOrder), 0, 8).array()));
    }

    public Int64(byte value) throws RangeOutOfBoundsException {
        super(BigInteger.valueOf(value));
    }

    public Int64(short value) throws RangeOutOfBoundsException {
        super(BigInteger.valueOf(value));
    }

    public Int64(int value) throws RangeOutOfBoundsException {
        super(BigInteger.valueOf(value));
    }

    public Int64(long value) throws RangeOutOfBoundsException {
        super(BigInteger.valueOf(value));
    }

    public Int64(float value) throws RangeOutOfBoundsException {
        super(BigInteger.valueOf((long)value));
    }

    public Int64(double value) throws RangeOutOfBoundsException {
        super(BigInteger.valueOf((long)value));
    }

    public Int64(BigInteger value) throws RangeOutOfBoundsException {
        super(value);
    }

    public Int64(String value) throws RangeOutOfBoundsException {
        super(new BigInteger(value));
    }

    @Override
    public void setValue(byte value) throws RangeOutOfBoundsException {
        if ((long)value < Int64.getMinimumValue().longValue() || (long)value > Int64.getMaximumValue().longValue()) {
            throw new RangeOutOfBoundsException("The value for the Int64 data type is out of bounds!");
        }
        this.dataObject = BigInteger.valueOf(value);
    }

    @Override
    public void setValue(short value) throws RangeOutOfBoundsException {
        if ((long)value < Int64.getMinimumValue().longValue() || (long)value > Int64.getMaximumValue().longValue()) {
            throw new RangeOutOfBoundsException("The value for the Int64 data type is out of bounds!");
        }
        this.dataObject = BigInteger.valueOf(value);
    }

    @Override
    public void setValue(int value) throws RangeOutOfBoundsException {
        if ((long)value < Int64.getMinimumValue().longValue() || (long)value > Int64.getMaximumValue().longValue()) {
            throw new RangeOutOfBoundsException("The value for the Int64 data type is out of bounds!");
        }
        this.dataObject = BigInteger.valueOf(value);
    }

    @Override
    public void setValue(long value) throws RangeOutOfBoundsException {
        if (value < Int64.getMinimumValue().longValue() || value > Int64.getMaximumValue().longValue()) {
            throw new RangeOutOfBoundsException("The value for the Int64 data type is out of bounds!");
        }
        this.dataObject = BigInteger.valueOf(value);
    }

    @Override
    public void setValue(float value) throws RangeOutOfBoundsException {
        if (!(value >= (float)Int64.getMinimumValue().longValue()) || !(value <= (float)Int64.getMaximumValue().longValue())) {
            throw new RangeOutOfBoundsException("The value for the Int64 data type is out of bounds!");
        }
        this.dataObject = BigInteger.valueOf((long)value);
    }

    @Override
    public void setValue(double value) throws RangeOutOfBoundsException {
        if (!(value >= (double)Int64.getMinimumValue().longValue()) || !(value <= (double)Int64.getMaximumValue().longValue())) {
            throw new RangeOutOfBoundsException("The value for the Int64 data type is out of bounds!");
        }
        this.dataObject = BigInteger.valueOf((long)value);
    }

    @Override
    public void setValue(BigInteger value) throws RangeOutOfBoundsException {
        if (value.compareTo(Int64.getMinimumValue()) <= 0 && !value.equals(Int64.getMinimumValue()) || value.compareTo(Int64.getMaximumValue()) >= 0 && !value.equals(Int64.getMaximumValue())) {
            throw new RangeOutOfBoundsException("The value for the Int64 data type is out of bounds!");
        }
        this.dataObject = value;
    }

    @Override
    public void setValue(String value) throws RangeOutOfBoundsException {
        BigInteger convertedValue = new BigInteger(value);
        this.setValue(convertedValue);
    }

    @Override
    public byte[] getAsBytes(ByteOrder byteOrder) throws RangeOutOfBoundsException {
        if (byteOrder == null) {
            byteOrder = ByteOrder.nativeOrder();
        }
        byte[] byteArray = ((BigInteger)this.dataObject).toByteArray();
        byte[] buffer = new byte[8];
        boolean isValueNegative = ((BigInteger)this.dataObject).compareTo(BigInteger.ZERO) < 0;
        IntStream.range(0, 8 - byteArray.length).forEachOrdered(index -> {
            buffer[index] = isValueNegative ? -1 : 0;
        });
        IntStream.range(8 - byteArray.length, 8).forEachOrdered(index -> {
            buffer[index] = byteArray[index - (8 - byteArray.length)];
        });
        return this.getBytesAsBigEndianByteOrder(buffer, byteOrder);
    }

    public boolean equals(Int64 int64) {
        return Objects.equals(this.dataObject, int64.getValue());
    }

    public static short getByteLength() {
        return 8;
    }

    public static BigInteger getMinimumValue() {
        return BigInteger.valueOf(Long.MIN_VALUE);
    }

    public static BigInteger getMaximumValue() {
        return BigInteger.valueOf(Long.MAX_VALUE);
    }
}

