/*
 * Decompiled with CFR 0.152.
 */
package club.psychose.library.ibo.datatypes.types.signed;

import club.psychose.library.ibo.datatypes.IBODataType;
import club.psychose.library.ibo.exceptions.RangeOutOfBoundsException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;

public final class Int8
extends IBODataType<Short> {
    public Int8(byte[] dataBytes) throws RangeOutOfBoundsException {
        super(ByteBuffer.wrap(dataBytes, 0, 2).getShort());
    }

    public Int8(byte[] dataBytes, ByteOrder byteOrder) throws RangeOutOfBoundsException {
        super(ByteBuffer.wrap(dataBytes, 0, 2).order(byteOrder).getShort());
    }

    public Int8(byte value) throws RangeOutOfBoundsException {
        super(Short.valueOf(value));
    }

    public Int8(short value) throws RangeOutOfBoundsException {
        super(value);
    }

    public Int8(int value) throws RangeOutOfBoundsException {
        super((short)value);
    }

    public Int8(long value) throws RangeOutOfBoundsException {
        super((short)value);
    }

    public Int8(float value) throws RangeOutOfBoundsException {
        super((short)value);
    }

    public Int8(double value) throws RangeOutOfBoundsException {
        super((short)value);
    }

    public Int8(BigInteger value) throws RangeOutOfBoundsException {
        super(value.shortValue());
    }

    public Int8(String value) throws RangeOutOfBoundsException {
        super(Short.parseShort(value));
    }

    @Override
    public void setValue(byte value) throws RangeOutOfBoundsException {
        if (value < Int8.getMinimumValue() || value > Int8.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the Int8 data type is out of bounds!");
        }
        this.dataObject = (short)value;
    }

    @Override
    public void setValue(Short value) throws RangeOutOfBoundsException {
        this.setValue((short)value);
    }

    @Override
    public void setValue(short value) throws RangeOutOfBoundsException {
        if (value < Int8.getMinimumValue() || value > Int8.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the Int8 data type is out of bounds!");
        }
        this.dataObject = value;
    }

    @Override
    public void setValue(int value) throws RangeOutOfBoundsException {
        if (value < Int8.getMinimumValue() || value > Int8.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the Int8 data type is out of bounds!");
        }
        this.dataObject = (short)value;
    }

    @Override
    public void setValue(long value) throws RangeOutOfBoundsException {
        if (value < (long)Int8.getMinimumValue() || value > (long)Int8.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the Int8 data type is out of bounds!");
        }
        this.dataObject = (short)value;
    }

    @Override
    public void setValue(float value) throws RangeOutOfBoundsException {
        if (!(value >= (float)Int8.getMinimumValue()) || !(value <= (float)Int8.getMaximumValue())) {
            throw new RangeOutOfBoundsException("The value for the Int8 data type is out of bounds!");
        }
        this.dataObject = (short)value;
    }

    @Override
    public void setValue(double value) throws RangeOutOfBoundsException {
        if (!(value >= (double)Int8.getMinimumValue()) || !(value <= (double)Int8.getMaximumValue())) {
            throw new RangeOutOfBoundsException("The value for the Int8 data type is out of bounds!");
        }
        this.dataObject = (short)value;
    }

    @Override
    public void setValue(BigInteger value) throws RangeOutOfBoundsException {
        BigInteger convertedMinimumValue = BigInteger.valueOf(Int8.getMinimumValue());
        BigInteger convertedMaximumValue = BigInteger.valueOf(Int8.getMaximumValue());
        if (value.compareTo(convertedMinimumValue) <= 0 && !value.equals(convertedMinimumValue) || value.compareTo(convertedMaximumValue) >= 0 && !value.equals(convertedMaximumValue)) {
            throw new RangeOutOfBoundsException("The value for the Int8 data type is out of bounds!");
        }
        this.dataObject = value.shortValue();
    }

    @Override
    public void setValue(String value) throws RangeOutOfBoundsException {
        short convertedValue = Short.parseShort(value);
        if (convertedValue < Int8.getMinimumValue() || convertedValue > Int8.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the Int8 data type is out of bounds!");
        }
        this.dataObject = convertedValue;
    }

    @Override
    public byte[] getAsBytes(ByteOrder byteOrder) {
        byte shortByte = ((Short)this.dataObject).byteValue();
        byte[] byteAsByteArray = byteOrder != null ? ByteBuffer.allocate(1).order(byteOrder).put(shortByte).array() : ByteBuffer.allocate(1).put(shortByte).array();
        return byteAsByteArray;
    }

    public boolean equals(Int8 int8) {
        return Objects.equals(this.dataObject, int8.getValue());
    }

    public static short getByteLength() {
        return 1;
    }

    public static short getMinimumValue() {
        return -128;
    }

    public static short getMaximumValue() {
        return 127;
    }
}

