/*
 * Decompiled with CFR 0.152.
 */
package club.psychose.library.ibo.datatypes.types.unsigned;

import club.psychose.library.ibo.datatypes.IBODataType;
import club.psychose.library.ibo.exceptions.RangeOutOfBoundsException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;

public final class UInt16
extends IBODataType<Integer> {
    public UInt16(byte[] dataBytes) throws RangeOutOfBoundsException {
        super(Short.toUnsignedInt(ByteBuffer.wrap(dataBytes, 0, 2).getShort()));
    }

    public UInt16(byte[] dataBytes, ByteOrder byteOrder) throws RangeOutOfBoundsException {
        super(Short.toUnsignedInt(ByteBuffer.wrap(dataBytes, 0, 2).order(byteOrder).getShort()));
    }

    public UInt16(byte value) throws RangeOutOfBoundsException {
        super(value & 0xFF);
    }

    public UInt16(short value) throws RangeOutOfBoundsException {
        super(Integer.valueOf(value));
    }

    public UInt16(int value) throws RangeOutOfBoundsException {
        super(value);
    }

    public UInt16(long value) throws RangeOutOfBoundsException {
        super((int)value);
    }

    public UInt16(float value) throws RangeOutOfBoundsException {
        super((int)value);
    }

    public UInt16(double value) throws RangeOutOfBoundsException {
        super((int)value);
    }

    public UInt16(BigInteger value) throws RangeOutOfBoundsException {
        super(value.intValue());
    }

    public UInt16(String value) throws RangeOutOfBoundsException {
        super(Integer.parseInt(value));
    }

    @Override
    public void setValue(byte value) throws RangeOutOfBoundsException {
        int convertedValue = value & 0xFF;
        if (convertedValue < UInt16.getMinimumValue() || convertedValue > UInt16.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the UInt16 data type is out of bounds!");
        }
        this.dataObject = convertedValue;
    }

    @Override
    public void setValue(short value) throws RangeOutOfBoundsException {
        if (value < UInt16.getMinimumValue() || value > UInt16.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the UInt16 data type is out of bounds!");
        }
        this.dataObject = (int)value;
    }

    @Override
    public void setValue(Integer value) throws RangeOutOfBoundsException {
        this.setValue((int)value);
    }

    @Override
    public void setValue(int value) throws RangeOutOfBoundsException {
        if (value < UInt16.getMinimumValue() || value > UInt16.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the UInt16 data type is out of bounds!");
        }
        this.dataObject = value;
    }

    @Override
    public void setValue(long value) throws RangeOutOfBoundsException {
        if (value < (long)UInt16.getMinimumValue() || value > (long)UInt16.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the UInt16 data type is out of bounds!");
        }
        this.dataObject = (int)value;
    }

    @Override
    public void setValue(float value) throws RangeOutOfBoundsException {
        if (!(value >= (float)UInt16.getMinimumValue()) || !(value <= (float)UInt16.getMaximumValue())) {
            throw new RangeOutOfBoundsException("The value for the UInt16 data type is out of bounds!");
        }
        this.dataObject = (int)value;
    }

    @Override
    public void setValue(double value) throws RangeOutOfBoundsException {
        if (!(value >= (double)UInt16.getMinimumValue()) || !(value <= (double)UInt16.getMaximumValue())) {
            throw new RangeOutOfBoundsException("The value for the UInt16 data type is out of bounds!");
        }
        this.dataObject = (int)value;
    }

    @Override
    public void setValue(BigInteger value) throws RangeOutOfBoundsException {
        BigInteger convertedMinimumValue = BigInteger.valueOf(UInt16.getMinimumValue());
        BigInteger convertedMaximumValue = BigInteger.valueOf(UInt16.getMaximumValue());
        if (value.compareTo(convertedMinimumValue) <= 0 && !value.equals(convertedMinimumValue) || value.compareTo(convertedMaximumValue) >= 0 && !value.equals(convertedMaximumValue)) {
            throw new RangeOutOfBoundsException("The value for the UInt16 data type is out of bounds!");
        }
        this.dataObject = value.intValue();
    }

    @Override
    public void setValue(String value) throws RangeOutOfBoundsException {
        int convertedValue = Integer.parseInt(value);
        if (convertedValue < UInt16.getMinimumValue() || convertedValue > UInt16.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the UInt16 data type is out of bounds!");
        }
        this.dataObject = convertedValue;
    }

    @Override
    public byte[] getAsBytes(ByteOrder byteOrder) throws RangeOutOfBoundsException {
        byte[] integerBytes = byteOrder != null ? ByteBuffer.allocate(4).order(byteOrder).putInt((Integer)this.dataObject).array() : ByteBuffer.allocate(4).putInt((Integer)this.dataObject).array();
        return this.extractBytes(integerBytes, byteOrder, 2, 2, false);
    }

    public boolean equals(UInt16 uInt16) {
        return Objects.equals(this.dataObject, uInt16.getValue());
    }

    public static short getByteLength() {
        return 2;
    }

    public static short getMinimumValue() {
        return 0;
    }

    public static int getMaximumValue() {
        return 65535;
    }
}

