/*
 * Decompiled with CFR 0.152.
 */
package club.psychose.library.ibo.datatypes.types.unsigned;

import club.psychose.library.ibo.datatypes.IBODataType;
import club.psychose.library.ibo.exceptions.RangeOutOfBoundsException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;

public final class UInt32
extends IBODataType<Long> {
    public UInt32(byte[] dataBytes) throws RangeOutOfBoundsException {
        super(Long.valueOf(ByteBuffer.wrap(dataBytes, 0, 4).getInt()));
    }

    public UInt32(byte[] dataBytes, ByteOrder byteOrder) throws RangeOutOfBoundsException {
        super(Long.valueOf(ByteBuffer.wrap(dataBytes, 0, 4).order(byteOrder).getInt()));
    }

    public UInt32(byte value) throws RangeOutOfBoundsException {
        super(Long.valueOf(value & 0xFF));
    }

    public UInt32(short value) throws RangeOutOfBoundsException {
        super(Long.valueOf(value));
    }

    public UInt32(int value) throws RangeOutOfBoundsException {
        super(Long.valueOf(value));
    }

    public UInt32(long value) throws RangeOutOfBoundsException {
        super(value);
    }

    public UInt32(float value) throws RangeOutOfBoundsException {
        super((long)value);
    }

    public UInt32(double value) throws RangeOutOfBoundsException {
        super((long)value);
    }

    public UInt32(BigInteger value) throws RangeOutOfBoundsException {
        super(value.longValue());
    }

    public UInt32(String value) throws RangeOutOfBoundsException {
        super(Long.parseLong(value));
    }

    @Override
    public void setValue(byte value) throws RangeOutOfBoundsException {
        long convertedValue = value & 0xFF;
        if (convertedValue < UInt32.getMinimumValue() || convertedValue > UInt32.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the UInt32 data type is out of bounds!");
        }
        this.dataObject = convertedValue;
    }

    @Override
    public void setValue(short value) throws RangeOutOfBoundsException {
        if ((long)value < UInt32.getMinimumValue() || (long)value > UInt32.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the UInt32 data type is out of bounds!");
        }
        this.dataObject = (long)value;
    }

    @Override
    public void setValue(int value) throws RangeOutOfBoundsException {
        if ((long)value < UInt32.getMinimumValue() || (long)value > UInt32.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the UInt32 data type is out of bounds!");
        }
        this.dataObject = (long)value;
    }

    @Override
    public void setValue(Long value) throws RangeOutOfBoundsException {
        this.setValue((long)value);
    }

    @Override
    public void setValue(long value) throws RangeOutOfBoundsException {
        if (value < UInt32.getMinimumValue() || value > UInt32.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the UInt32 data type is out of bounds!");
        }
        this.dataObject = value;
    }

    @Override
    public void setValue(float value) throws RangeOutOfBoundsException {
        if (!(value >= (float)UInt32.getMinimumValue()) || !(value <= (float)UInt32.getMaximumValue())) {
            throw new RangeOutOfBoundsException("The value for the UInt32 data type is out of bounds!");
        }
        this.dataObject = (long)value;
    }

    @Override
    public void setValue(double value) throws RangeOutOfBoundsException {
        if (!(value >= (double)UInt32.getMinimumValue()) || !(value <= (double)UInt32.getMaximumValue())) {
            throw new RangeOutOfBoundsException("The value for the UInt32 data type is out of bounds!");
        }
        this.dataObject = (long)value;
    }

    @Override
    public void setValue(BigInteger value) throws RangeOutOfBoundsException {
        BigInteger convertedMinimumValue = BigInteger.valueOf(UInt32.getMinimumValue());
        BigInteger convertedMaximumValue = BigInteger.valueOf(UInt32.getMaximumValue());
        if (value.compareTo(convertedMinimumValue) <= 0 && !value.equals(convertedMinimumValue) || value.compareTo(convertedMaximumValue) >= 0 && !value.equals(convertedMaximumValue)) {
            throw new RangeOutOfBoundsException("The value for the UInt32 data type is out of bounds!");
        }
        this.dataObject = value.longValue();
    }

    @Override
    public void setValue(String value) throws RangeOutOfBoundsException {
        long convertedValue = Long.parseLong(value);
        if (convertedValue < UInt32.getMinimumValue() || convertedValue > UInt32.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the UInt32 data type is out of bounds!");
        }
        this.dataObject = convertedValue;
    }

    @Override
    public byte[] getAsBytes(ByteOrder byteOrder) throws RangeOutOfBoundsException {
        byte[] longBytes = byteOrder != null ? ByteBuffer.allocate(8).order(byteOrder).putLong((Long)this.dataObject).array() : ByteBuffer.allocate(8).putLong((Long)this.dataObject).array();
        return this.extractBytes(longBytes, byteOrder, 4, 4, false);
    }

    public boolean equals(UInt32 uInt32) {
        return Objects.equals(this.dataObject, uInt32.getValue());
    }

    public static short getByteLength() {
        return 4;
    }

    public static long getMinimumValue() {
        return 0L;
    }

    public static long getMaximumValue() {
        return 0xFFFFFFFFL;
    }
}

