/*
 * Decompiled with CFR 0.152.
 */
package club.psychose.library.ibo.datatypes.types.unsigned;

import club.psychose.library.ibo.datatypes.IBODataType;
import club.psychose.library.ibo.exceptions.RangeOutOfBoundsException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import java.util.stream.IntStream;

public final class UInt64
extends IBODataType<BigInteger> {
    public UInt64(byte[] dataBytes) throws RangeOutOfBoundsException {
        super(BigInteger.valueOf(0L));
        this.setValue(new BigInteger(1, ByteBuffer.wrap(this.getBytesAsBigEndianByteOrder(dataBytes, null), 0, 8).array()));
    }

    public UInt64(byte[] dataBytes, ByteOrder byteOrder) throws RangeOutOfBoundsException {
        super(BigInteger.valueOf(0L));
        this.setValue(new BigInteger(1, ByteBuffer.wrap(this.getBytesAsBigEndianByteOrder(dataBytes, byteOrder), 0, 8).array()));
    }

    public UInt64(byte value) throws RangeOutOfBoundsException {
        super(BigInteger.valueOf(value & 0xFF));
    }

    public UInt64(short value) throws RangeOutOfBoundsException {
        super(BigInteger.valueOf(value));
    }

    public UInt64(int value) throws RangeOutOfBoundsException {
        super(BigInteger.valueOf(value));
    }

    public UInt64(long value) throws RangeOutOfBoundsException {
        super(BigInteger.valueOf(value));
    }

    public UInt64(float value) throws RangeOutOfBoundsException {
        super(BigInteger.valueOf((long)value));
    }

    public UInt64(double value) throws RangeOutOfBoundsException {
        super(BigInteger.valueOf((long)value));
    }

    public UInt64(BigInteger value) throws RangeOutOfBoundsException {
        super(value);
    }

    public UInt64(String value) throws RangeOutOfBoundsException {
        super(new BigInteger(value));
    }

    @Override
    public void setValue(byte value) throws RangeOutOfBoundsException {
        BigInteger convertedValue = BigInteger.valueOf(value & 0xFF);
        if (convertedValue.longValue() < UInt64.getMinimumValue().longValue() || convertedValue.longValue() > UInt64.getMaximumValue().longValue()) {
            throw new RangeOutOfBoundsException("The value for the UInt64 data type is out of bounds!");
        }
        this.dataObject = convertedValue;
    }

    @Override
    public void setValue(short value) throws RangeOutOfBoundsException {
        if ((long)value < UInt64.getMinimumValue().longValue() || (long)value > UInt64.getMaximumValue().longValue()) {
            throw new RangeOutOfBoundsException("The value for the UInt64 data type is out of bounds!");
        }
        this.dataObject = BigInteger.valueOf(value);
    }

    @Override
    public void setValue(int value) throws RangeOutOfBoundsException {
        if ((long)value < UInt64.getMinimumValue().longValue() || (long)value > UInt64.getMaximumValue().longValue()) {
            throw new RangeOutOfBoundsException("The value for the UInt64 data type is out of bounds!");
        }
        this.dataObject = BigInteger.valueOf(value);
    }

    @Override
    public void setValue(long value) throws RangeOutOfBoundsException {
        if (value < UInt64.getMinimumValue().longValue() || value > UInt64.getMaximumValue().longValue()) {
            throw new RangeOutOfBoundsException("The value for the UInt64 data type is out of bounds!");
        }
        this.dataObject = BigInteger.valueOf(value);
    }

    @Override
    public void setValue(float value) throws RangeOutOfBoundsException {
        if (!(value >= (float)UInt64.getMinimumValue().longValue()) || !(value <= (float)UInt64.getMaximumValue().longValue())) {
            throw new RangeOutOfBoundsException("The value for the UInt64 data type is out of bounds!");
        }
        this.dataObject = BigInteger.valueOf((long)value);
    }

    @Override
    public void setValue(double value) throws RangeOutOfBoundsException {
        if (!(value >= (double)UInt64.getMinimumValue().longValue()) || !(value <= (double)UInt64.getMaximumValue().longValue())) {
            throw new RangeOutOfBoundsException("The value for the UInt64 data type is out of bounds!");
        }
        this.dataObject = BigInteger.valueOf((long)value);
    }

    @Override
    public void setValue(BigInteger value) throws RangeOutOfBoundsException {
        if (value.compareTo(UInt64.getMinimumValue()) <= 0 && !value.equals(UInt64.getMinimumValue()) || value.compareTo(UInt64.getMaximumValue()) >= 0 && !value.equals(UInt64.getMaximumValue())) {
            throw new RangeOutOfBoundsException("The value for the UInt64 data type is out of bounds!");
        }
        this.dataObject = value;
    }

    @Override
    public void setValue(String value) throws RangeOutOfBoundsException {
        BigInteger convertedValue = new BigInteger(value);
        this.setValue(convertedValue);
    }

    @Override
    public byte[] getAsBytes(ByteOrder byteOrder) throws RangeOutOfBoundsException {
        if (byteOrder == null) {
            byteOrder = ByteOrder.nativeOrder();
        }
        byte[] byteArray = ((BigInteger)this.dataObject).toByteArray();
        byte[] buffer = new byte[8];
        boolean isValueNegative = ((BigInteger)this.dataObject).compareTo(BigInteger.ZERO) < 0;
        IntStream.range(0, 8 - byteArray.length).forEachOrdered(index -> {
            buffer[index] = isValueNegative ? -1 : 0;
        });
        IntStream.range(8 - byteArray.length, 8).forEachOrdered(index -> {
            buffer[index] = byteArray[index - (8 - byteArray.length)];
        });
        return this.getBytesAsBigEndianByteOrder(buffer, byteOrder);
    }

    public boolean equals(UInt64 uInt64) {
        return Objects.equals(this.dataObject, uInt64.getValue());
    }

    public static short getByteLength() {
        return 8;
    }

    public static BigInteger getMinimumValue() {
        return BigInteger.valueOf(0L);
    }

    public static BigInteger getMaximumValue() {
        return new BigInteger("18446744073709551615");
    }
}

