/*
 * Decompiled with CFR 0.152.
 */
package club.psychose.library.ibo.datatypes.types.unsigned;

import club.psychose.library.ibo.datatypes.IBODataType;
import club.psychose.library.ibo.exceptions.RangeOutOfBoundsException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;

public final class UInt8
extends IBODataType<Short> {
    public UInt8(byte[] dataBytes) throws RangeOutOfBoundsException {
        super(ByteBuffer.wrap(dataBytes, 0, 1).getShort());
    }

    public UInt8(byte[] dataBytes, ByteOrder byteOrder) throws RangeOutOfBoundsException {
        super(ByteBuffer.wrap(dataBytes, 0, 1).order(byteOrder).getShort());
    }

    public UInt8(byte value) throws RangeOutOfBoundsException {
        super((short)(value & 0xFF));
    }

    public UInt8(short value) throws RangeOutOfBoundsException {
        super(value);
    }

    public UInt8(int value) throws RangeOutOfBoundsException {
        super((short)value);
    }

    public UInt8(long value) throws RangeOutOfBoundsException {
        super((short)value);
    }

    public UInt8(float value) throws RangeOutOfBoundsException {
        super((short)value);
    }

    public UInt8(double value) throws RangeOutOfBoundsException {
        super((short)value);
    }

    public UInt8(BigInteger value) throws RangeOutOfBoundsException {
        super(value.shortValue());
    }

    public UInt8(String value) throws RangeOutOfBoundsException {
        super(Short.parseShort(value));
    }

    @Override
    public void setValue(byte value) throws RangeOutOfBoundsException {
        short convertedValue = (short)(value & 0xFF);
        if (convertedValue < UInt8.getMinimumValue() || convertedValue > UInt8.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the UInt8 data type is out of bounds!");
        }
        this.dataObject = convertedValue;
    }

    @Override
    public void setValue(Short value) throws RangeOutOfBoundsException {
        this.setValue((short)value);
    }

    @Override
    public void setValue(short value) throws RangeOutOfBoundsException {
        if (value < UInt8.getMinimumValue() || value > UInt8.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the UInt8 data type is out of bounds!");
        }
        this.dataObject = value;
    }

    @Override
    public void setValue(int value) throws RangeOutOfBoundsException {
        if (value < UInt8.getMinimumValue() || value > UInt8.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the UInt8 data type is out of bounds!");
        }
        this.dataObject = (short)value;
    }

    @Override
    public void setValue(long value) throws RangeOutOfBoundsException {
        if (value < (long)UInt8.getMinimumValue() || value > (long)UInt8.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the UInt8 data type is out of bounds!");
        }
        this.dataObject = (short)value;
    }

    @Override
    public void setValue(float value) throws RangeOutOfBoundsException {
        if (!(value >= (float)UInt8.getMinimumValue()) || !(value <= (float)UInt8.getMaximumValue())) {
            throw new RangeOutOfBoundsException("The value for the UInt8 data type is out of bounds!");
        }
        this.dataObject = (short)value;
    }

    @Override
    public void setValue(double value) throws RangeOutOfBoundsException {
        if (!(value >= (double)UInt8.getMinimumValue()) || !(value <= (double)UInt8.getMaximumValue())) {
            throw new RangeOutOfBoundsException("The value for the UInt8 data type is out of bounds!");
        }
        this.dataObject = (short)value;
    }

    @Override
    public void setValue(BigInteger value) throws RangeOutOfBoundsException {
        BigInteger convertedMinimumValue = BigInteger.valueOf(UInt8.getMinimumValue());
        BigInteger convertedMaximumValue = BigInteger.valueOf(UInt8.getMaximumValue());
        if (value.compareTo(convertedMinimumValue) <= 0 && !value.equals(convertedMinimumValue) || value.compareTo(convertedMaximumValue) >= 0 && !value.equals(convertedMaximumValue)) {
            throw new RangeOutOfBoundsException("The value for the UInt8 data type is out of bounds!");
        }
        this.dataObject = value.shortValue();
    }

    @Override
    public void setValue(String value) throws RangeOutOfBoundsException {
        short convertedValue = Short.parseShort(value);
        if (convertedValue < UInt8.getMinimumValue() || convertedValue > UInt8.getMaximumValue()) {
            throw new RangeOutOfBoundsException("The value for the UInt8 data type is out of bounds!");
        }
        this.dataObject = convertedValue;
    }

    @Override
    public byte[] getAsBytes(ByteOrder byteOrder) throws RangeOutOfBoundsException {
        byte[] shortBytes = byteOrder != null ? ByteBuffer.allocate(2).order(byteOrder).putShort((Short)this.dataObject).array() : ByteBuffer.allocate(2).putShort((Short)this.dataObject).array();
        return this.extractBytes(shortBytes, byteOrder, 1, 1, false);
    }

    public boolean equals(UInt8 uInt8) {
        return Objects.equals(this.dataObject, uInt8.getValue());
    }

    public static short getByteLength() {
        return 1;
    }

    public static short getMinimumValue() {
        return 0;
    }

    public static short getMaximumValue() {
        return 255;
    }
}

